/*
 * #%L
 * EUGene :: Maven plugin
 * 
 * $Id: Xmi2ObjectModel.java 863 2010-04-15 14:22:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.0.1/maven-eugene-plugin/src/main/java/org/nuiton/eugene/plugin/Xmi2ObjectModel.java $
 * %%
 * Copyright (C) 2006 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.eugene.plugin;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.File;
import java.io.IOException;

/**
 * Converti les fichiers XMI en fichier ObjectModel
 * 
 * @goal xmi2objectmodel
 *
 * @requiresDependencyResolution compile
 * @requiresProject
 */
public class Xmi2ObjectModel extends Xmi2Model {

    @Override
    public void doAction() throws Exception {
        getLog().info("Conversion of XMI files into ObjectModel");
        super.doAction();
    }

    @Override
    public String getExtension() {
        return "objectmodel";
    }

    @Override
    protected String getStyleSheet(File model) {
        String styleSheet = null;

        String version = getXmiVersion(model);
        if (version.startsWith("1.")) {
            styleSheet = "xmi1.2ToObjectModel.xsl";
        } else if (version.startsWith("2.")) {
            styleSheet = "xmi2.1ToObjectModel.xsl";
        } else {
            getLog().error("Unsupported xmi version [" + version + "]");
        }
        
        return styleSheet;
    }

    /**
     * Try to find xmi version on a file.
     * 
     * @param xmiFile
     *            file to inspect
     * @return version or null if version can't have been found
     */
    protected String getXmiVersion(File xmiFile) {
        String version = null;

        SAXParserFactory factory = SAXParserFactory.newInstance();

        try {
            SAXParser parser = factory.newSAXParser();

            XmiVersionHandler handler = new XmiVersionHandler();
            parser.parse(xmiFile, handler);

            version = handler.getVersion();
        } catch (ParserConfigurationException e) {
            getLog().debug("Can't parse file as xmi", e);
        } catch (SAXException e) {
            getLog().debug("Can't parse file as xmi", e);
        } catch (IOException e) {
            getLog().debug("Can't parse file as xmi", e);
        }

        return version;
    }

    /**
     * Sax handler to find xmi version into xmi document.
     */
    protected class XmiVersionHandler extends DefaultHandler {

        public String version;

        public XmiVersionHandler() {
        }

        public String getVersion() {
            return version;
        }

        @Override
        public void startElement(String uri, String localName, String qName,
                Attributes attributes) throws SAXException {

            if (qName.equals("XMI")) {
                version = attributes.getValue("xmi.version");
                getLog().debug("XMI version found : " + version);
            }

            if (version == null) {
                version = attributes.getValue("xmi:version");
                getLog().debug("XMI version found : " + version);
            }

        }
    }

}
