package org.nuiton.eugene.plantuml;

/*
 * #%L
 * EUGene :: PlantUML templates
 * $Id: PlantumlTemplatesGenerator.java 1262 2013-05-29 10:06:05Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.6.3/eugene-plantuml-templates/src/main/java/org/nuiton/eugene/plantuml/PlantumlTemplatesGenerator.java $
 * %%
 * Copyright (C) 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * TODO
 *
 * @author agiraudet
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.eugene.plantuml.PlantumlTemplatesGenerator"
 * @since 2.6.3
 */
public class PlantumlTemplatesGenerator extends ObjectModelGenerator {

    private boolean _loginit = true;

    private void log(String str) {
        try {
            FileWriter log;
            String path = "/tmp/log.yaml.txt";

            if (_loginit) {
                log = new FileWriter(path, false);
                log.close();
                _loginit = false;
            }
            log = new FileWriter(path, true);
            log.write("[LOG] " + str + "\n");
            log.close();
        } catch (IOException e) {
            ;
        }
    }

    @Override
    public void generateFromModel(Writer output, ObjectModel input) throws IOException {
        //log
        //log

        // utiliser le systeme de templates a l'avenir

        Map<ObjectModelAttribute, ObjectModelClassifier> linksOME = new LinkedHashMap<ObjectModelAttribute, ObjectModelClassifier>();

        // debut du fichier
        output.write("@startuml\n\n");
        // parcours des classes
        for (ObjectModelClass class_tmp : input.getClasses()) {
            // sale
            String classStereotype = "";
            if (class_tmp.getStereotypes().size() > 0) {
                classStereotype = "<<";
                boolean first = true;
                for (String str : class_tmp.getStereotypes()) {
                    if (first) {
                        classStereotype = classStereotype + str;
                        first = false;
                    } else {
                        classStereotype = classStereotype + " ," + str;
                    }
                }
                classStereotype = classStereotype + ">>";
            }
            /*if(class_tmp.getStereotypes().contains("entity"))
            {
                classStereotype = " <<entity>>";
            }*/
            String className = class_tmp.getName();
            // ajout de la classe
            output.write("class " + className + classStereotype + " {\n");
            // parcours des attributs de la classe
            for (ObjectModelAttribute attribute_tmp : class_tmp.getAttributes()) {
                String attributeName = attribute_tmp.getName();
                //String attributeType = afterLastPoint(attribute_tmp.getType());
                String attributeType = attribute_tmp.getType();
                // si l'attribut n'est lie a aucune classe
                if (attribute_tmp.referenceClassifier()) {
                    // ajout du lien
                    linksOME.put(attribute_tmp, class_tmp);
                } else {
                    // ajout de l'attribut
                    output.write("  -" + attributeName + " : " + attributeType + "\n");
                }
            }
            // parcours des operations
            for (ObjectModelOperation operation_tmp : class_tmp.getOperations()) {
                String operationName = operation_tmp.getName();
                //String operationReturnType = afterLastPoint(operation_tmp.getReturnType());
                String operationReturnType = operation_tmp.getReturnType();
                // ajout de l'operation
                output.write("  +" + operationName + "(");
                // parcours des parametres
                boolean first = true;
                for (ObjectModelParameter param : operation_tmp.getParameters()) {
                    String parameterName = param.getName();
                    //String parameterType = afterLastPoint(param.getType());
                    String parameterType = param.getType();
                    if (first) {
                        first = false;
                    } else {
                        output.write(", ");
                    }
                    // ajout du parametre
                    output.write(parameterName + " : " + parameterType);
                }
                // ajout du type de retour
                output.write(") : " + operationReturnType + "\n");// attention aux listes !
            }
            output.write("}\n\n");

        }

        // parcours des enumerations
        for (ObjectModelEnumeration enumeration_tmp : input.getEnumerations()) {
            String enumerationName = enumeration_tmp.getName();
            String enumerationStereotype = "";
            if (enumeration_tmp.getStereotypes().contains("entity")) {
                enumerationStereotype = " <<entity>>";
            }
            // ajout de l'enumeration
            output.write("enum " + enumerationName + enumerationStereotype + " {\n");
            output.write("}\n\n");
        }

        // parcours des interfaces
        for (ObjectModelInterface interface_tmp : input.getInterfaces()) {
            String interfaceName = interface_tmp.getName();
            String interfaceStereotype = "";
            if (interface_tmp.getStereotypes().contains("entity")) {
                interfaceStereotype = " <<entity>>";
            }
            // ajout de l'interface
            output.write("interface " + interfaceName + interfaceStereotype + " {\n");
            // ajout des methodes
            output.write("}\n\n");
        }

        //liaisons
        for (ObjectModelAttribute attribute_tmp : linksOME.keySet()) {
            if (attribute_tmp.isComposite() && attribute_tmp.referenceClassifier()) {
                output.write(linksOME.get(attribute_tmp).getName() + " *-- " + attribute_tmp.getClassifier().getName() + "\n");
            } else if (attribute_tmp.isAggregate() && attribute_tmp.referenceClassifier())//else if
            {
                output.write(linksOME.get(attribute_tmp).getName() + " o-- " + attribute_tmp.getClassifier().getName() + "\n");
            } else if (!attribute_tmp.isNavigable() && attribute_tmp.referenceClassifier())//probleme avec les compositions et aggregations -> double lien
            {
                output.write(attribute_tmp.getClassifier().getName() + " --> " + linksOME.get(attribute_tmp).getName() + "\n");
            } else if (attribute_tmp.isNavigable() && attribute_tmp.referenceClassifier()) {
                output.write(attribute_tmp.getClassifier().getName() + " -- " + linksOME.get(attribute_tmp).getName() + "\n");
            }
        }

        //classes d'association
        Map<String, LinkedList<String>> associationClass = new LinkedHashMap<String, LinkedList<String>>();
        for (ObjectModelClassifier classifier : input.getClassifiers()) {
            for (ObjectModelAttribute attribute : classifier.getAttributes()) {
                if (attribute.hasAssociationClass()) {
                    String key = attribute.getAssociationClass().getName();
                    String value = classifier.getName();
                    if (associationClass.containsKey(key)) {
                        associationClass.get(key).add(value);
                    } else {
                        associationClass.put(key, new LinkedList<String>());
                        associationClass.get(key).add(value);
                    }
                }
            }
        }
        for (Map.Entry<String, LinkedList<String>> entry : associationClass.entrySet()) {
            boolean first = true;
            output.write("(");
            for (String value : entry.getValue()) {
                if (first) {
                    output.write(value);
                    first = false;
                } else {
                    output.write(", " + value);
                }
            }
            output.write(") .. " + entry.getKey() + "\n");
        }

        //extensions/generalisations (heritage)
        for (ObjectModelClass classOM : input.getClasses()) {
            for (ObjectModelClass superClassOM : classOM.getSuperclasses()) {
                output.write(superClassOM.getName() + " <|-- " + classOM.getName());
            }
        }

        // fin du fichier
        output.write("\n@enduml");
    }

    // exemple : afterLastPoint("org.nuiton.testeugene.generator") return "generator"
    public static String afterLastPoint(String input) {
        String str = new StringBuffer(input).reverse().toString();
        String res = "";
        for (Character car : str.toCharArray()) {
            if (car.equals('.')) {
                return res;
            } else {
                res = car.toString() + res;
            }
        }
        return res;
    }

    @Override
    public void applyTemplate(ObjectModel model, File destDir) throws IOException {
        super.applyTemplate(model, destDir);
        try {
            File plantuml = new File(destDir + File.separator + this.getFilenameForModel(model));
            SourceFileReader reader = new SourceFileReader(plantuml);
            List<GeneratedImage> lst = reader.getGeneratedImages();
            new File(lst.get(0).getPngFile(), destDir + File.separator + model.getName() + ".png");
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFilenameForModel(ObjectModel model) {
        return model.getName() + ".plantuml";
    }
}
