/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.renderer;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.tagvalue.TagValueDefinition;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;
import org.nuiton.eugene.plugin.renderer.AbstractEugeneReportRenderer;

public class TagValuesReportRenderer
extends AbstractEugeneReportRenderer<TagValueDefinitionProvider, TagValueDefinition> {
    public TagValuesReportRenderer(Sink sink, I18N i18n, Locale locale, String bundleName, String javaDocDestDir, String jxrDestDir, TagValueDefinitionProvider data) {
        super(sink, i18n, locale, bundleName, javaDocDestDir, jxrDestDir, data);
    }

    @Override
    protected Map<String, TagValueDefinition> getDataDetails() {
        return ((TagValueDefinitionProvider)this.data).getDefinition();
    }

    @Override
    protected void renderSummaryTable(TagValueDefinitionProvider provider, Map<String, TagValueDefinition> details) {
        if (MapUtils.isEmpty(details)) {
            this.sink.text(this.getText("report.noTagValues"));
        } else {
            this.sink.section3();
            this.sink.sectionTitle3();
            this.sink.text(this.getText("report.summary.tagValues"));
            this.sink.sectionTitle3_();
            this.sink.lineBreak();
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.tagValue.name"));
            this.sinkHeaderCellText(this.getText("report.tagValue.description"));
            this.sink.tableRow_();
            for (Map.Entry<String, TagValueDefinition> entry : details.entrySet()) {
                String tagValueName = entry.getKey();
                TagValueDefinition tagValueDefinition = entry.getValue();
                this.sink.tableRow();
                this.sinkCellLink(tagValueName, "./" + this.bundleName + ".html#detail_" + tagValueName);
                this.sinkCellText(tagValueDefinition.documentation());
                this.sink.tableRow_();
            }
            this.sink.table_();
            this.sink.section3_();
        }
    }

    @Override
    protected void renderDetail(String key, TagValueDefinition detail) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.anchor("detail_" + key);
        this.sink.text(this.getText("report.detail.tagValue.title") + "   " + key);
        this.sink.anchor_();
        this.sink.sectionTitle2_();
        this.sink.lineBreak();
        this.sink.table();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.tagValue.name"));
        this.sinkCellText(key);
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.tagValue.description"));
        this.sinkCellText(detail.documentation());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.tagValue.defaultValue"));
        this.sinkCellText(detail.defaultValue());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.tagValue.matcherClass"));
        this.sinkCellText(detail.matcherClass().getName());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.tagValue.target"));
        this.sink.tableCell();
        this.renderTargets(detail.target());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(this.getText("report.detail.tagValue.usage.title"));
        this.sink.sectionTitle3_();
        this.sink.text("//TODO Example of usage of this tag value");
        this.sink.section3_();
        this.sink.section2_();
    }

    @Override
    protected String getEugeneDocLink() {
        String url = this.locale.getCountry().equals(Locale.FRENCH.getCountry()) ? "http://doc.nuiton.org/eugene/fr/eugene/tagValues.html" : "http://doc.nuiton.org/eugene/eugene/tagValues.html";
        return url;
    }
}

