/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

public class Register
extends PollenActionSupportForEdition {
    private static final long serialVersionUID = 1L;
    protected UserAccount pollenUserAccount;
    protected String password2;

    public UserAccount getPollenUserAccount() {
        if (this.pollenUserAccount == null) {
            this.pollenUserAccount = this.getUserService().getNewUser();
        }
        return this.pollenUserAccount;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getLogin())) {
            this.addFieldError("pollenUserAccount.login", this._("pollen.error.login.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getPassword())) {
            this.addFieldError("pollenUserAccount.password", this._("pollen.error.password.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getPassword2())) {
            this.addFieldError("password2", this._("pollen.error.password2.required", new Object[0]));
        }
        if (ObjectUtils.notEqual((Object)this.getPassword2(), (Object)this.pollenUserAccount.getPassword())) {
            this.addFieldError("password2", this._("pollen.error.passwords.not.equals", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getEmail())) {
            this.addFieldError("pollenUserAccount.email", this._("pollen.error.email.required", new Object[0]));
        } else if (!StringUtil.isEmail((String)this.pollenUserAccount.getEmail())) {
            this.addFieldError("pollenUserAccount.email", this._("pollen.error.email.invalid", new Object[0]));
        }
    }

    public String execute() throws Exception {
        String result = "input";
        try {
            UserAccount createdUser = this.getUserService().createUser(this.pollenUserAccount, false);
            this.getPollenSession().setUserAccount(createdUser);
            this.addFlashMessage(this._("pollen.information.your.are.loggued", new Object[0]));
            result = "success";
        }
        catch (UserLoginAlreadyUsedException e) {
            this.addFieldError("pollenUserAccount.login", this._("pollen.error.user.login.already.used", new Object[0]));
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("pollenUserAccount.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        this.pollenUserAccount.setPassword(null);
        this.password2 = null;
        return result;
    }
}

