/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

public class Register
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected UserAccount user;
    protected String password2;

    public UserAccount getUser() {
        if (this.user == null) {
            this.user = this.getUserService().getNewUser();
        }
        return this.user;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.user.getLogin())) {
            this.addFieldError("user.login", this._("pollen.error.login.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.user.getPassword())) {
            this.addFieldError("user.password", this._("pollen.error.password.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getPassword2())) {
            this.addFieldError("password2", this._("pollen.error.password2.required", new Object[0]));
        }
        if (ObjectUtils.notEqual((Object)this.getPassword2(), (Object)this.user.getPassword())) {
            this.addFieldError("password2", this._("pollen.error.passwords.not.equals", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.user.getEmail())) {
            this.addFieldError("user.email", this._("pollen.error.email.required", new Object[0]));
        } else if (!StringUtil.isEmail((String)this.user.getEmail())) {
            this.addFieldError("user.email", this._("pollen.error.email.invalid", new Object[0]));
        }
    }

    public String execute() throws Exception {
        String result = "input";
        try {
            UserAccount createdUser = this.getUserService().createUser(this.user, false);
            this.getPollenSession().setUserAccount(createdUser);
            this.addFlashMessage(this._("pollen.information.your.are.loggued", new Object[0]));
            result = "success";
        }
        catch (UserLoginAlreadyUsedException e) {
            this.addFieldError("user.login", this._("pollen.error.user.login.already.used", new Object[0]));
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("user.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        this.user.setPassword(null);
        this.password2 = null;
        return result;
    }
}

