/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;

public class SummaryPoll
extends AbstractPollUriIdAction
implements ServletRequestAware {
    private static final long serialVersionUID = 1L;
    private Poll poll;
    private SecurityService.AccountIdRole accountIdRole;
    private transient HttpServletRequest request;

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public String getVoteUrl() {
        PollUrl url = this.getPollUrlService().getPollVoteUrl(this.poll);
        if (this.poll.getPollType() == PollType.FREE) {
            this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        }
        return url.getUrl();
    }

    public String getModerateUrl() {
        PollUrl url = this.getPollUrlService().getPollModerateUrl(this.poll);
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public String getEditUrl() {
        PollUrl url = this.getPollUrlService().getPollEditUrl(this.poll);
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public String getCloneUrl() {
        PollUrl url = this.getPollUrlService().getPollCloneUrl(this.poll);
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public String getExportUrl() {
        PollUrl url = this.getPollUrlService().getPollExportUrl(this.poll);
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = this.getPollUrlService().getPollResultUrl(this.poll);
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public boolean isCanClose() {
        return this.getSecurityService().isCanClosePoll(this.poll, this.accountIdRole);
    }

    public boolean isCanShowResult() {
        String errorMessage = this.getSecurityService().isCanAccessResult(this.poll, this.accountIdRole);
        return errorMessage == null;
    }

    public boolean isCanVote() {
        String accountId = this.getAccountId();
        if (this.accountIdRole == SecurityService.AccountIdRole.CREATOR) {
            accountId = null;
        }
        return this.getSecurityService().isCanVote(this.poll, accountId, this.accountIdRole);
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.getUriId());
        String pollId = this.getUriId().getPollId();
        this.poll = this.getPollService().getExistingPollByPollId(pollId);
        this.accountIdRole = PollenUIUtils.getAccountIdRole((ServletRequest)this.request);
        return "success";
    }
}

