/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AbstractPollUriIdAction.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AbstractPollUriIdAction.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.ui.actions.PollUriConverter;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import java.util.Map;

/**
 * Abstract action for all actions with a poll uri id.
 *
 * @author tchemit <chemit@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 * @since 1.3
 */
public abstract class AbstractPollUriIdAction extends PollenActionSupport {
    
    public static final String PARAM_POLL_URI = "uriId";

    private static final long serialVersionUID = 1L;
    
    private PollUri pollUri;

    public final PollUri getUriId() {
        return pollUri;
    }

    public final void setUriId(PollUri pollUri) {
        this.pollUri = pollUri;
    }

    public final String getPollId() {
        return pollUri != null ? pollUri.getPollId() : null;
    }

    public final String getAccountId() {
        return pollUri != null ? pollUri.getAccountId() : null;
    }

    protected void preparePollUri(Map<String, String[]> parameters) {
        if (pollUri == null) {
            String[] values = parameters.get(PARAM_POLL_URI);
            pollUri = PollUriConverter.convertFromString(values);
        }
    }

    protected void preparePollUri(String pollId, String accountId) {
        pollUri = PollUri.newPollUri(pollId, accountId);
    }
}
