/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class DeleteFavoriteList
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String favoriteListId;
    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setFavoriteListId(String favoriteListId) {
        this.favoriteListId = favoriteListId;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteListId);
        String result = "input";
        try {
            FavoriteService service = (FavoriteService)this.newService(FavoriteService.class);
            PersonList favoriteList = (PersonList)service.getEntityById(PersonList.class, this.favoriteListId);
            PersonList deletedFavoritedList = service.deleteFavoriteList(this.getPollenUserAccount(), favoriteList);
            this.getTransaction().commitTransaction();
            this.addFlashMessage(this._("pollen.information.favoriteList.deleted", new Object[]{deletedFavoritedList.getName()}));
            result = "success";
        }
        catch (UserNotFoundException e) {
            this.addFieldError("deleteUser.login", this._("pollen.error.user.not.found", new Object[0]));
        }
        return result;
    }
}

