/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: PollenUIUtils.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/PollenUIUtils.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui;

import org.apache.struts2.ServletActionContext;
import org.chorem.pollen.PollenTechnicalException;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Useful ui methods.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenUIUtils {

    /** Keep the servlet context */
    private static ServletContext servletContext;

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        PollenUIUtils.servletContext = servletContext;
    }

    public static void redirect(String url) throws Exception {

        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();

        String path = request.getContextPath();
        if (!url.startsWith("/")) {
            path += "/";
        }
        response.sendRedirect(path + url);
    }

    public static URL getApplicationBase(HttpServletRequest request) {

        // get port
        String port;
        if ("http".equalsIgnoreCase(request.getScheme()) && request.getServerPort() != 80 ||
            "https".equalsIgnoreCase(request.getScheme()) && request.getServerPort() != 443) {
            port = ":" + request.getServerPort();
        } else {
            port = "";
        }

        String applicationBase = request.getScheme() + "://" + request.getServerName() +
                                 port + request.getContextPath();
        try {
            return new URL(applicationBase);
        } catch (MalformedURLException e) {
            throw new PollenTechnicalException(
                    "Could not compute pollen url", e);
        }
    }

    protected PollenUIUtils() {
    }
}
