/*
 * #%L
 * Pollen :: Services
 * $Id: PollResult.java 3556 2012-06-25 17:56:45Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-services/src/main/java/org/chorem/pollen/bean/PollResult.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.chorem.pollen.common.ChoiceType;

import java.io.Serializable;

/**
 * Classe DTO représentant un résultat de sondage.
 *
 * @since 1.3
 */
public class PollResult implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    private String name;

    private String value;

    private String pollId;

    private ChoiceType choiceType;

    private int voteCountingType;

    private boolean byGroup;

    private boolean hidden;

    public PollResult() {

    }

    public PollResult(String id) {
        this.id = id;
    }

    public PollResult(String name,
                      String pollId,
                      ChoiceType choiceType,
                      int voteCountingType) {
        super();
        this.name = name;
        this.pollId = pollId;
        this.choiceType = choiceType;
        this.voteCountingType = voteCountingType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public ChoiceType getChoiceType() {
        return choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public int getVoteCountingType() {
        return voteCountingType;
    }

    public void setVoteCountingType(int voteCountingType) {
        this.voteCountingType = voteCountingType;
    }

    public boolean isByGroup() {
        return byGroup;
    }

    public void setByGroup(boolean byGroup) {
        this.byGroup = byGroup;
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).
                append("name", name).
                append("value", value).
                toString();
    }
}
