/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor.demo;

import fr.reseaumexico.editor.demo.MexicoEditorDemoUI;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.event.InputDesignFactorEvent;
import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioEvent;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import fr.reseaumexico.model.parser.InputDesignParser;
import fr.reseaumexico.model.writer.InputDesignXmlWriter;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MexicoEditorDemoUIHandler {
    private static Log log = LogFactory.getLog(MexicoEditorDemoUIHandler.class);
    private final MexicoEditorDemoUI ui;

    public MexicoEditorDemoUIHandler(MexicoEditorDemoUI ui) {
        this.ui = ui;
    }

    public void closeApplication() {
        this.ui.dispose();
    }

    public MexicoEditorDemoUI initUI() {
        this.ui.setVisible(true);
        ErrorDialogUI.init((Frame)this.ui);
        return this.ui;
    }

    public void openFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(I18n._((String)"jmexico.file.open.dialog", (Object[])new Object[0]));
        int returnVal = fileChooser.showOpenDialog(this.ui);
        if (returnVal == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.loadInputFile(selectedFile);
        }
    }

    public void loadInputFile(File selectedFile) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Load input file: " + selectedFile));
        }
        InputDesign inputDesign = this.readInputDesignFile(selectedFile);
        inputDesign.addInputDesignFactorListener(new InputDesignFactorListener(){

            public void factorValueChanged(InputDesignFactorEvent event) {
                MexicoEditorDemoUIHandler.this.ui.setInputDesign(event.getSource());
            }
        });
        inputDesign.addInputDesignScenarioListener(new InputDesignScenarioListener(){

            public void scenarioAdded(InputDesignScenarioEvent event) {
                MexicoEditorDemoUIHandler.this.ui.setInputDesign(event.getSource());
            }

            public void scenarioRemoved(InputDesignScenarioEvent event) {
                MexicoEditorDemoUIHandler.this.ui.setInputDesign(event.getSource());
            }

            public void scenarioRenamed(InputDesignScenarioEvent event) {
                MexicoEditorDemoUIHandler.this.ui.setInputDesign(event.getSource());
            }
        });
        this.ui.setInputDesign(inputDesign);
        this.ui.getModel().setInputDesignFile(selectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        File selectedFile = this.ui.getModel().getInputDesignFile();
        try {
            InputDesignXmlWriter writer = new InputDesignXmlWriter(this.ui.getInputDesign());
            try {
                writer.write(selectedFile);
            }
            finally {
                this.ui.getModel().setOptionChanged(false);
            }
        }
        catch (IOException eee) {
            log.error((Object)("Failed to save inputDesign file '" + selectedFile.getName() + "'"), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    protected InputDesign readInputDesignFile(File selectedFile) {
        InputDesign result = null;
        try {
            InputDesignParser parser = new InputDesignParser();
            result = (InputDesign)parser.getModel(selectedFile);
        }
        catch (Exception eee) {
            log.error((Object)("Failed to read inputDesign file '" + selectedFile.getName() + "'"), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        return result;
    }
}

