/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.CloseApplicationAction;
import fr.ird.observe.ui.actions.ReloadStorageAction;
import javax.swing.ImageIcon;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public enum ObserveUICallback implements Runnable
{
    application(I18n.n((String)"observe.action.reload.application", (Object[])new Object[0]), "application-reload"){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload application");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUIHandler handler = new ObserveMainUIHandler();
            ObserveMainUI ui = handler.getUI((JAXXContext)context);
            context.askReload();
            new CloseApplicationAction(ui).run();
        }
    }
    ,
    ui(I18n.n((String)"observe.action.reload.ui", (Object[])new Object[0]), "ui-reload"){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload ui");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUIHandler handler = new ObserveMainUIHandler();
            ObserveMainUI ui = handler.getUI((JAXXContext)context);
            ObserveConfig config = ui.getConfig();
            handler.reloadUI(context, config);
        }
    }
    ,
    db(I18n.n((String)"observe.action.reload.storage", (Object[])new Object[0]), "db-reload"){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload db");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUIHandler handler = new ObserveMainUIHandler();
            ObserveMainUI ui = handler.getUI((JAXXContext)context);
            new ReloadStorageAction(ui).run();
        }
    };

    private static final Log log;
    private final String label;
    private final String iconPath;

    private ObserveUICallback(String label, String iconPath) {
        this.iconPath = iconPath;
        this.label = label;
        this.getIcon();
    }

    public ImageIcon getIcon() {
        ImageIcon icon = UIHelper.createActionIcon((String)this.iconPath);
        return icon;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        log = LogFactory.getLog(ObserveUICallback.class);
    }
}

