/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.export;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeDAO;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.export.ExportUI;
import fr.ird.observe.ui.admin.export.MareeEntry;
import fr.ird.observe.ui.admin.export.MareeToExportTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ExportUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ExportUIHandler.class);

    public ExportUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, ExportUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getPrepareAction().setText(I18n._((String)"observe.action.synchro.prepare.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        tabUI.getStartAction().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        tabUI.getModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("selection model changed to " + value));
                }
                selectTabUI.getSelectionModel().clearSelection();
                selectTabUI.getSelectionRenderer().setExistingMareeIds(model.getExportModel().getExistingMareeIds());
                ExportUIHandler.this.updateSelectionModel(selectTabUI);
            }
        });
        final JTable table4 = tabUI.getMarees();
        table4.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)0, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)3, (int)20);
        DefaultTableCellRenderer renderer5 = new DefaultTableCellRenderer();
        UIHelper.setI18nTableHeaderRenderer((JTable)table4, (String[])new String[]{I18n.n_((String)"observe.synchro.table.exportData.selected", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.selected.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.programme.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.programme.label.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.maree.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.maree.label.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.exist.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.exportData.exist.label.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table4, (int)0, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer5));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, Programme.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, Maree.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer5));
        UIHelper.setTableColumnEditor((JTable)table4, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table4.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table4.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table4.convertColumnIndexToModel(colIndex)) == 0) {
                    MareeToExportTableModel model;
                    boolean oldValue = (model = (MareeToExportTableModel)table4.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
    }

    public void updateState(ExportUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            tabUI.mareesModel.init(tabUI.getStepModel().getData());
            return;
        }
        if (newState == WizardState.RUNNING) {
            // empty if block
        }
    }

    public void doPrepareAction() {
        ExportUI tabUI = (ExportUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getPrepareAction().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ExportUIHandler.this.prepareAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public void doStartAction() {
        ExportUI tabUI = (ExportUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartAction().getToolTipText();
        int[] rows = tabUI.getMareesModel().getSelected();
        tabUI.getModel().getExportModel().setExportDataSelectedIndex(rows);
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ExportUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardState prepareAction() throws Exception {
        DecoratorService decoratorProvider = this.getDecoratorService();
        ExportModel stepModel = this.model.getExportModel();
        Decorator pDecorator = decoratorProvider.getDecorator(Programme.class);
        Decorator mDecorator = decoratorProvider.getDecorator(Maree.class);
        stepModel.setProgrammeDecorator((Decorator<Programme>)pDecorator);
        stepModel.setMareeDecorator((Decorator<Maree>)mDecorator);
        DataSource centralSource = this.model.getSafeCentralSource(false);
        stepModel.setCentralSource(centralSource);
        if (!centralSource.canWriteData()) {
            this.sendMessage(I18n._((String)"observe.message.can.not.write.data", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        DataSource source = this.getSource();
        stepModel.setSource(source);
        this.openSource(centralSource);
        this.openSource(source);
        this.sendMessage(I18n._((String)"observe.message.exportData.prepare.data", (Object[])new Object[0]));
        String txName = "prepareData";
        List<String> existingMarees = stepModel.getExistingMareeIds();
        ArrayList<MareeEntry> entries = new ArrayList<MareeEntry>();
        DataSelectionModel selectionModel = this.model.getSelectionDataModel();
        Map datas = selectionModel.getSelectedDataByProgramme();
        TopiaContext tx = this.beginTransaction(source, txName);
        try {
            for (String p : datas.keySet()) {
                List marees = (List)datas.get(p);
                if (marees == null || marees.isEmpty()) continue;
                for (String m : marees) {
                    MareeEntry entry = new MareeEntry();
                    Maree maree = (Maree)tx.findByTopiaId(m);
                    entry.setMaree(maree);
                    mDecorator.toString((Object)maree);
                    String mareeKey = AdminUIModel.getMareeKey(maree);
                    entry.setExist(existingMarees.contains(mareeKey));
                    entries.add(entry);
                }
            }
        }
        finally {
            this.closeTransaction(source, tx, txName);
        }
        stepModel.setData(entries);
        if (entries.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.exportData.not.possible", (Object[])new Object[0]));
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardState.CANCELED;
        }
        this.sendMessage(I18n._((String)"observe.message.exportData.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardState.NEED_FIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardState doAction() throws Exception {
        ExportModel stepModel = this.model.getExportModel();
        Decorator<Programme> pDecorator = stepModel.getProgrammeDecorator();
        Decorator<Maree> mDecorator = stepModel.getMareeDecorator();
        ArrayList<MareeEntry> entries = new ArrayList<MareeEntry>();
        int[] selectedIndex = stepModel.getExportDataSelectedIndex();
        List<MareeEntry> data = stepModel.getData();
        DataSource centralSource = stepModel.getCentralSource();
        DataSource source = stepModel.getSource();
        for (int index : selectedIndex) {
            entries.add(data.get(index));
        }
        String txName = "deleteMarees";
        TopiaContext tx = this.beginTransaction(centralSource, txName);
        try {
            MareeDAO dao = ObserveDAOHelper.getMareeDAO((TopiaContext)tx);
            for (MareeEntry entry : entries) {
                Maree m;
                String mareeId = entry.getMareeId();
                String programmeId = entry.getProgrammeId();
                if (!entry.isExist().booleanValue() || (m = (Maree)dao.findByTopiaId(mareeId)) == null) continue;
                Programme p = m.getProgramme();
                this.sendMessage(I18n._((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{mDecorator.toString((Object)m), pDecorator.toString((Object)p)}));
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{mareeId, programmeId}));
                }
                dao.delete((TopiaEntity)m);
            }
            this.commitTransaction(centralSource, tx, txName);
        }
        catch (Exception e) {
            this.rollbackTransaction(centralSource, tx, txName);
            this.model.getExportModel().setError(e);
            WizardState i$ = WizardState.FAILED;
            return i$;
        }
        finally {
            this.closeTransaction(centralSource, tx, txName);
        }
        for (MareeEntry entry : entries) {
            String mareeId = entry.getMareeId();
            String programmeId = entry.getProgrammeId();
            Maree m = entry.getMaree();
            Programme p = m.getProgramme();
            this.sendMessage(I18n._((String)"observe.message.exportData.replicate.maree", (Object[])new Object[]{mDecorator.toString((Object)m), pDecorator.toString((Object)p)}));
            if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"observe.message.exportData.replicate.maree", (Object[])new Object[]{mareeId, programmeId}));
            }
            try {
                this.replicateData(source, centralSource, mareeId);
            }
            catch (Exception e) {
                this.model.getExportModel().setError(e);
                return WizardState.FAILED;
            }
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }
}

