/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.constants.SexeEnum;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.EchantillonFauneUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class EchantillonFauneUIHandler
extends ContentTableUIHandler<EchantillonFaune, TailleFaune> {
    private static Log log = LogFactory.getLog(EchantillonFauneUIHandler.class);
    JAXXContextEntryDef<List<EspeceFaune>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");

    public static ContentTableUIModel<EchantillonFaune, TailleFaune> newModel(EchantillonFauneUI ui) {
        return new ContentTableUIModel<EchantillonFaune, TailleFaune>(EchantillonFaune.class, TailleFaune.class, new String[]{"tailleFaune", "commentaire"}, new String[]{"espece", "longueur", "longueurCalcule", "poids", "poidsCalcule", "sexe", "referencePhoto"}, ui, ContentTableModel.newTableMeta(TailleFaune.class, "espece", false), ContentTableModel.newTableMeta(TailleFaune.class, "longueur", false), ContentTableModel.newTableMeta(TailleFaune.class, "poids", false), new ContentTableMeta<TailleFaune>(TailleFaune.class, "sexe", false){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNullValue(ContentTableModel<?, ?> m, TailleFaune bean, int row) {
                return bean.getSexe() == -1;
            }
        }, ContentTableModel.newTableMeta(TailleFaune.class, "referencePhoto", false));
    }

    public EchantillonFauneUIHandler(EchantillonFauneUI ui) {
        super(ui);
    }

    @Override
    public EchantillonFauneUI getUi() {
        return (EchantillonFauneUI)super.getUi();
    }

    @Override
    protected EchantillonFaune loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        Collection data;
        List especes;
        if (mode == ContentMode.UPDATE) {
            String caleeId = dataContext.getSelectedCaleeId();
            especes = dataService.getAvailableEspeceForEchantillonFaune(dataSource, caleeId);
        } else {
            especes = new ArrayList();
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), especes);
        String id = dataContext.getSelectedCaleeId();
        id = dataService.getEchantillonFauneId(dataSource, id);
        EchantillonFaune editBean = (EchantillonFaune)this.getBean();
        if (id == null) {
            this.getLoadBinder().copy(null, (Object)editBean, new String[0]);
            data = new ArrayList();
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
            data = this.loadChilds(editBean);
        }
        this.getChildsUpdator().setChilds((TopiaEntity)editBean, data);
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(EchantillonFaune bean, List<TailleFaune> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create " + bean + " for " + caleeId));
            }
            this.getDataService().create(this.getDataSource(), caleeId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        return true;
    }

    @Override
    protected EchantillonFaune onCreate(TopiaContext tx, Object parent, EchantillonFaune editBean) throws TopiaException {
        Calee parentBean = (Calee)parent;
        EchantillonFaune beanToSave = (EchantillonFaune)ObserveDAOHelper.getEchantillonFauneDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addEchantillonFaune(beanToSave);
        return beanToSave;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean canUse;
        ContentMode mode;
        block4: {
            mode = super.getContentMode(dataContext);
            if (mode != ContentMode.UPDATE) {
                return mode;
            }
            canUse = false;
            try {
                String caleeId = this.getDataContext().getSelectedCaleeId();
                canUse = this.getDataService().canUseEchantillonFaune(this.getDataSource(), caleeId);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)e);
            }
        }
        if (!canUse) {
            mode = ContentMode.READ;
            EchantillonFauneUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetFaune"));
        }
        return mode;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleFaune bean, boolean create) {
        BeanComboBox<EspeceFaune> requestFocus;
        List<EspeceFaune> availableEspeces;
        EspeceFaune espece = bean == null ? null : bean.getEspece();
        EchantillonFauneUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected espece " + espece));
        }
        if (create) {
            availableEspeces = new ArrayList<EspeceFaune>((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getEspece();
        } else {
            availableEspeces = Arrays.asList(espece);
            requestFocus = ui.getLongueur();
        }
        ui.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonFaune.especeFaune"), I18n.n_((String)"observe.table.echantillonFaune.especeFaune.tip"), I18n.n_((String)"observe.table.echantillonFaune.longueur"), I18n.n_((String)"observe.table.echantillonFaune.longueur.tip"), I18n.n_((String)"observe.table.echantillonFaune.poids"), I18n.n_((String)"observe.table.echantillonFaune.poids.tip"), I18n.n_((String)"observe.table.echantillonFaune.sexe"), I18n.n_((String)"observe.table.echantillonFaune.sexe.tip"), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto"), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, SexeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)renderer);
    }
}

