/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import com.healthmarketscience.jackcess.Database;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.access.AccessConfigUI;
import fr.ird.observe.ui.admin.access.AccessDataSource;
import fr.ird.observe.ui.admin.access.AccessEntity;
import fr.ird.observe.ui.admin.access.AccessEntityMeta;
import fr.ird.observe.ui.admin.access.AccessHitModel;
import fr.ird.observe.ui.admin.access.AccessModel;
import fr.ird.observe.ui.admin.access.AccessUI;
import fr.ird.observe.ui.admin.access.AnalyzeAccessUI;
import fr.ird.observe.ui.admin.access.EntityBuilder;
import fr.ird.observe.ui.admin.access.HitModel;
import fr.ird.observe.ui.admin.access.ImportAccessException;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class AccessUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(AccessUIHandler.class);

    public AccessUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, AnalyzeAccessUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())}));
        log.info((Object)("Init extra configuration for " + tabUI.getName()));
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        AccessConfigUI extraConfig = new AccessConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add(extraConfig);
    }

    public void initTabUI(AdminUI ui, AccessUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())}));
        Decorator decorator = this.getDecoratorService().getDecorator(Programme.class);
        BeanComboBox<Programme> combo = tabUI.getSelectProgramme();
        combo.init((JXPathDecorator)decorator, new ArrayList());
    }

    public void startAnalyzeAction() {
        AnalyzeAccessUI tabUI = (AnalyzeAccessUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return AccessUIHandler.this.doAnalyzeAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public void startImportAction() {
        AccessUI tabUI = (AccessUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return AccessUIHandler.this.doImportAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState doAnalyzeAction() throws Exception {
        log.debug((Object)this);
        try {
            this.analyzeAccessDB(this.getStepModel());
        }
        catch (Exception e) {
            this.getUi().getStepModel().setError(e);
            return WizardState.FAILED;
        }
        this.sendMessage(I18n._((String)"observe.message.analyze.access.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    public WizardState doImportAction() throws Exception {
        log.debug((Object)this);
        try {
            AccessModel model = this.getStepModel();
            this.prepareStorage(model);
            DataSource source = model.getTmpSource();
            AccessUIHandler.importAccessDB(model, source, (AccessUI)this.getUi(), true);
            this.ui.getContextValue(StorageUIHandler.class).backupLocalDatabase(source, model.getOutputFile(), null);
        }
        catch (Exception e) {
            this.getUi().getStepModel().setError(e);
            return WizardState.FAILED;
        }
        this.sendMessage(I18n._((String)"observe.message.access.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeAccessDB(AccessModel model) throws Exception {
        Database conn = Database.open((File)model.getImportFile());
        model.setAccessConnexion(conn);
        model.initAccessDataSource();
        AccessDataSource db = model.getAccessDataSource();
        AccessEntityMeta<?>[] metas = db.getMetas();
        if (log.isDebugEnabled()) {
            log.debug((Object)("registred entity metas  : " + metas.length));
        }
        AccessHitModel totalHits = model.getTotalHits();
        PropertyChangeListener createListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                Long newValue = (Long)evt.getNewValue();
                String message = "[" + property + "] find " + newValue + " objects to import.";
                log.info((Object)message);
            }
        };
        totalHits.addPropertyChangeListener(createListener);
        try {
            boolean safe = db.loadDb(totalHits);
            String message = db.generateAnalyseReport(totalHits, this.getDecoratorService());
            this.sendMessage(message);
            if (!safe) {
                log.info((Object)("Detected tables : " + Arrays.toString(db.getTables())));
                throw new IllegalStateException(I18n._((String)"observe.error.invalid.access.db", (Object[])new Object[]{this.getStepModel().getImportFile().getName()}));
            }
        }
        finally {
            totalHits.removePropertyChangeListener(createListener);
        }
    }

    public static Component importAccessDB(AccessModel model, DataSource source, AccessUI tabUI, boolean showProgressUI) throws Exception {
        AccessHitModel totalHits = model.getTotalHits();
        AccessHitModel hits = model.getHits();
        boolean standaloneUI = tabUI == null;
        Component ui = null;
        if (showProgressUI) {
            ui = AccessUIHandler.createProgressPanel(model, standaloneUI);
            if (!standaloneUI) {
                JPanel p = (JPanel)ui;
                JPopupMenu m = tabUI.getProgressPopup();
                m.add(p);
                m.revalidate();
            }
        }
        AccessUIHandler handler = tabUI == null ? null : tabUI.getHandler();
        EntityBuilder builder = new EntityBuilder(model.getAccessDataSource(), source, model.getSelectedProgramme().getTopiaId());
        if (handler != null) {
            builder.setMessager(handler);
        }
        model.setBuilder(builder);
        Maree[] marees = model.getAccessMarees();
        log.info((Object)I18n._((String)"observe.access.import.detected.marees", (Object[])new Object[]{marees.length}));
        long tStart = System.nanoTime();
        for (Maree maree : marees) {
            AccessHitModel mareeHits = hits.getSnapshot();
            builder.clear();
            long t0 = System.nanoTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading " + maree));
            }
            try {
                builder.doVisit(maree, hits);
                HitModel touched = hits.applyTo((HitModel)mareeHits);
                long delay = System.nanoTime() - t0;
                long totalCreated = touched.getTotalHit();
                AccessEntity aEntity = (AccessEntity)maree;
                String message = String.format(I18n._((String)"observe.access.import.maree"), aEntity.getRowId() + " - " + Arrays.toString(aEntity.getPkey()), StringUtil.convertTime((long)delay), totalCreated, StringUtil.convertTime((long)(delay / totalCreated)));
                if (handler != null) {
                    handler.sendMessage(message);
                }
                log.info((Object)message);
                if (!log.isDebugEnabled()) continue;
                for (Map.Entry entry : touched) {
                    ObserveEntityEnum type = (ObserveEntityEnum)entry.getKey();
                    Long done = entry.getValue();
                    Long total = totalHits.getHit(type);
                    message = I18n._((String)"observe.access.import.maree.hit", (Object[])new Object[]{type, done, total});
                    log.debug((Object)message);
                }
            }
            catch (ImportAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (handler == null) continue;
                handler.sendMessage(e.getMessage() + " : " + e.getCause().getMessage());
            }
        }
        long tEnd = System.nanoTime();
        long delay = tEnd - tStart;
        String message = I18n._((String)"observe.access.import.resume", (Object[])new Object[]{marees.length, hits.getTotalHit(), totalHits.getTotalHit(), StringUtil.convertTime((long)delay)});
        log.info((Object)message);
        for (Map.Entry entry : hits) {
            ObserveEntityEnum type = (ObserveEntityEnum)entry.getKey();
            long total = totalHits.getHit(type);
            Long done = entry.getValue();
            message = I18n._((String)"observe.access.import.total.hit", (Object[])new Object[]{type, done, total});
            log.info((Object)message);
            if (handler == null) continue;
            handler.sendMessage(message);
        }
        return ui;
    }

    protected void prepareStorage(AccessModel stepModel) throws Exception {
        DataSource tmpSource = this.model.getSafeTmpSource(false);
        stepModel.setTmpSource(tmpSource);
        DataSource centralSource = this.getCentralSource();
        this.openSource(tmpSource);
        this.openSource(centralSource);
        this.replicateReferentiel(centralSource, tmpSource);
    }

    protected DataSource getCentralSource() {
        DataSource centralSource = this.getStepModel().getCentralSource();
        if (centralSource == null) {
            centralSource = this.model.getSafeCentralSource(false);
            this.getStepModel().setCentralSource(centralSource);
        }
        return centralSource;
    }

    public static Component createProgressPanel(AccessModel model, boolean standalone) {
        AccessHitModel hits = model.getHits();
        AccessHitModel totalHits = model.getTotalHits();
        JPanel toolBarsPane = new JPanel(new GridLayout(0, 3));
        JPanel p = new JPanel(new GridLayout(0, 3));
        Font font = p.getFont();
        font = font.deriveFont(1);
        JLabel done = new JLabel("Trait\u00e9");
        done.setFont(font);
        JLabel todo = new JLabel("A faire");
        todo.setFont(font);
        JLabel total = new JLabel("Total");
        total.setFont(font);
        p.add(todo);
        p.add(done);
        p.add(total);
        JLabel jLabel = new JLabel("");
        jLabel.setFont(font);
        toolBarsPane.add(jLabel);
        toolBarsPane.add(p);
        jLabel = new JLabel("Progression");
        jLabel.setFont(font);
        toolBarsPane.add(jLabel);
        String id = "progressBar_All";
        JProgressBar bar = new JProgressBar(0, (int)totalHits.getTotalHit());
        bar.setName(id);
        bar.setFont(font);
        p = new JPanel(new GridLayout(0, 3));
        done = new JLabel();
        done.setFont(font);
        todo = new JLabel();
        todo.setFont(font);
        total = new JLabel(bar.getMaximum() + "");
        total.setFont(font);
        p.add(todo);
        p.add(done);
        p.add(total);
        jLabel = new JLabel("Tous");
        jLabel.setFont(font);
        toolBarsPane.add(jLabel);
        toolBarsPane.add(p);
        toolBarsPane.add(bar);
        bar.setStringPainted(true);
        bar.setBorderPainted(false);
        bar.setMaximum((int)totalHits.getTotalHit());
        bar.setValue(0);
        hits.addPropertyChangeListener(new HitModelChangeListener(bar, done, todo){

            @Override
            protected Long getValue(PropertyChangeEvent evt) {
                AccessHitModel model = (AccessHitModel)evt.getSource();
                return model.getTotalHit();
            }
        });
        for (Map.Entry hit : totalHits) {
            bar = new JProgressBar(0, hit.getValue().intValue());
            bar.setStringPainted(true);
            bar.setBorderPainted(false);
            bar.setValue(0);
            String property = ((ObserveEntityEnum)hit.getKey()).name();
            p = new JPanel(new GridLayout(0, 3));
            done = new JLabel();
            todo = new JLabel();
            total = new JLabel(bar.getMaximum() + "");
            p.add(todo);
            p.add(done);
            p.add(total);
            hits.addPropertyChangeListener(property, new HitModelChangeListener(bar, done, todo));
            toolBarsPane.add(new JLabel(property));
            toolBarsPane.add(p);
            toolBarsPane.add(bar);
        }
        if (!standalone) {
            return toolBarsPane;
        }
        final JDialog d = new JDialog(ObserveContext.get().getObserveMainUI(), I18n._((String)"observe.title.import.access.progress"), false);
        d.setSize(640, 480);
        d.add(toolBarsPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                d.setVisible(true);
            }
        });
        return d;
    }

    protected AccessModel getStepModel() {
        return this.model.getAccessModel();
    }

    public void chooseImportFile() {
        AccessModel model = this.getModel().getAccessModel();
        File f = UIHelper.chooseFile(this.ui, I18n._((String)"observe.title.choose.importAccess"), I18n._((String)"observe.action.choose.importAccess"), model.getImportFile(), "^.+\\.mdb$", I18n._((String)"observe.action.choose.importAccess.description"));
        model.setImportFile(f);
    }

    public void chooseOutputFileDirectory(AccessConfigUI ui) {
        File f = UIHelper.chooseDirectory(this.getUi(), I18n._((String)"observe.title.choose.db.dump.directory"), I18n._((String)"observe.action.choose.db.dump.directory"), new File(ui.getOutputFileDirectoryText().getText()));
        this.changeOutputFileDirectory(ui, f);
    }

    public void changeOutputFileDirectory(AccessConfigUI ui, File f) {
        ui.getAccessModel().setOutputFile(new File(f, ui.getOutputFilenameText().getText()));
    }

    public void changeOutputFilename(AccessConfigUI ui, String filename) {
        ui.getAccessModel().setOutputFile(new File(ui.getOutputFileDirectoryText().getText(), filename));
    }

    public void updateProgrammes(AccessUI ui) {
        DataSource source = this.getCentralSource();
        try {
            this.openSource(source);
            List programmes = this.getDataService().getList(source, Programme.class);
            Programme selectedProgramme = this.getStepModel().getSelectedProgramme();
            BeanComboBox<Programme> combo = ui.getSelectProgramme();
            combo.setData(programmes);
            combo.setSelectedItem((Object)selectedProgramme);
        }
        catch (DataSourceException e) {
            log.error((Object)("Could not obtain list of programmes from " + source.getLabel()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static class HitModelChangeListener
    implements PropertyChangeListener {
        protected final JProgressBar bar;
        protected final JLabel todo;
        protected final JLabel done;

        public HitModelChangeListener(JProgressBar bar, JLabel done, JLabel todo) {
            this.bar = bar;
            this.todo = todo;
            this.done = done;
            if (bar.getMaximum() == 0) {
                bar.setString("-");
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Long newValue = this.getValue(evt);
            if (newValue != null) {
                this.bar.setValue(newValue.intValue());
            }
            this.todo.setText(this.bar.getMaximum() - this.bar.getValue() + "");
            this.done.setText(this.bar.getValue() + "");
        }

        protected Long getValue(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            Object value = evt.getNewValue();
            if (value == null || !(value instanceof Number)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("change [" + property + "] with new value " + value));
                }
                return null;
            }
            Long newValue = (Long)value;
            return newValue;
        }
    }
}

