/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveApplicationContext;
import fr.ird.observe.ObserveCLAction;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.event.DataSourceEvent;
import fr.ird.observe.db.event.DataSourceListener;
import fr.ird.observe.db.event.DataSourceListenerAdapter;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.actions.CancelCreateUIAction;
import fr.ird.observe.ui.actions.CloseAndCreateUIAction;
import fr.ird.observe.ui.actions.CloseOpenUIAction;
import fr.ird.observe.ui.actions.DeleteDataUIAction;
import fr.ird.observe.ui.actions.DeleteReferentielUIAction;
import fr.ird.observe.ui.actions.GoDownUIAction;
import fr.ird.observe.ui.actions.GoUpUIAction;
import fr.ird.observe.ui.actions.ReOpenUIAction;
import fr.ird.observe.ui.actions.ResetEditUIAction;
import fr.ird.observe.ui.actions.SaveEditUIAction;
import fr.ird.observe.ui.actions.SelectNodeUIAction;
import fr.ird.observe.ui.actions.SelectOpenNodeUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Component;
import java.awt.Container;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.ActionMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.jdbc.JdbcSQLException;
import org.hibernate.jmx.StatisticsService;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.framework.TopiaContextImplementor;

public class ObserveContext
extends ObserveApplicationContext {
    private static Log log = LogFactory.getLog(ObserveContext.class);
    private static final JAXXContextEntryDef<ObserveMainUI> MAIN_UI_ENTRY_DEF = UIHelper.newContextEntryDef((String)"mainui", ObserveMainUI.class);
    public static final JAXXContextEntryDef<ObserveCLAction> ACTIONS_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveCLAction.class);
    public static final JAXXContextEntryDef<ActionMap> ACTION_MAP_ENTRY_DEF = UIHelper.newContextEntryDef(ActionMap.class);
    protected final Object lock = new Object();

    public static ObserveContext get() throws IllegalStateException {
        return (ObserveContext)ObserveServiceHelper.get();
    }

    public static boolean isClosed() {
        return ObserveServiceHelper.isClosed();
    }

    public ObserveConfig getConfig() {
        return (ObserveConfig)super.getConfig();
    }

    public ObserveMainUI getObserveMainUI() {
        return (ObserveMainUI)MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get());
    }

    public ContentUI<?> getSelectedContentUI() {
        ObserveMainUI ui = this.getObserveMainUI();
        return this.getSelectedContentUI(ui);
    }

    public ContentUI<?> getSelectedContentUI(ObserveMainUI ui) {
        JPanel container;
        ContentUI result = null;
        if (ui == null) {
            return result;
        }
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ContentUI) {
            result = (ContentUI)((Object)currentContent);
        }
        return result;
    }

    public boolean closeSelectedContentUI() {
        ObserveMainUI ui = this.getObserveMainUI();
        return this.closeSelectedContentUI(ui);
    }

    public boolean closeSelectedContentUI(ObserveMainUI mainUI) {
        ContentUI<?> ui = this.getSelectedContentUI(mainUI);
        if (ui == null) {
            return true;
        }
        boolean closed = false;
        try {
            closed = ui.close();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
        return closed;
    }

    public ActionMap getActionMap() {
        return (ActionMap)ACTION_MAP_ENTRY_DEF.getContextValue((JAXXContext)this);
    }

    public void setObserveMainUI(ObserveMainUI ui) {
        MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)ObserveContext.get(), (Object)ui);
    }

    public void removeObserveMainUI() {
        MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void askReload() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ask to reload.");
        }
        ObserveRunner.getRunner().setReload(true);
    }

    public void initStorage(ObserveConfig config, ObserveMainUI mainUI, boolean askToCreate) {
        try {
            if (config.isLocalStorageExist()) {
                this.loadLocalStorage();
                mainUI.setMode(ObserveUIMode.DB);
            } else {
                mainUI.setMode(ObserveUIMode.NO_DB);
                if (askToCreate) {
                    this.createStorage(config, mainUI.getHandler());
                }
            }
            log.info((Object)I18n._((String)"observe.init.storage.done"));
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createStorage(ObserveConfig config, ObserveMainUIHandler uiHandler) {
        int reponse = UIHelper.askUser(I18n._((String)"observe.title.no.local.db.found"), I18n._((String)"observe.message.no.local.db.found", (Object[])new Object[]{config.getLocalDBDirectory()}), 3, new Object[]{I18n._((String)"observe.choice.useRemoteStorage"), I18n._((String)"observe.choice.createLocalStorage"), I18n._((String)"observe.choice.doNothing")}, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("response : " + reponse));
        }
        DbMode dbMode = null;
        String title = null;
        if (reponse != -1 && reponse < 2) {
            if (reponse == 1) {
                dbMode = DbMode.CREATE_LOCAL;
                title = I18n.n_((String)"observe.title.create.local.db");
            } else {
                dbMode = DbMode.USE_REMOTE;
                title = I18n.n_((String)"observe.title.load.remote.db");
            }
        }
        if (dbMode != null) {
            uiHandler.launchChangeStorage(this.getObserveMainUI(), dbMode, title);
        }
    }

    protected void loadLocalStorage() throws Exception {
        H2DataSource service = ObserveServiceHelper.newLocalStorageService((IObserveConfig)this.getConfig());
        this.prepareMainStorage((DataSource)service);
        log.info((Object)I18n._((String)"observe.init.local.db.detected", (Object[])new Object[]{service.getLabel()}));
        try {
            service.doOpen();
        }
        catch (Exception eee) {
            JdbcSQLException error;
            Throwable cause;
            for (cause = eee.getCause(); cause != null && cause.getCause() != null; cause = cause.getCause()) {
            }
            if (cause != null && cause instanceof JdbcSQLException && (error = (JdbcSQLException)cause).getMessage().contains("Locked")) {
                JOptionPane.showMessageDialog(null, I18n._((String)"observe.error.open.first.db"), I18n._((String)"observe.title.error.dialog"), 0);
                return;
            }
            throw eee;
        }
    }

    public void prepareMainStorage(DataSource service) {
        service.getConfig().setUseCache(true);
        if (ObserveCLAction.isUseJMX()) {
            service.getConfig().getDbConfig().setProperty("hibernate.generate_statistics", String.valueOf(true));
        }
        service.addDataSourceListener((DataSourceListener)new DataSourceListenerAdapter(){

            public void onOpening(DataSourceEvent event) {
                DataSource s = event.getSource();
                UIHelper.displayInfo(I18n._((String)"observe.message.db.loading", (Object[])new Object[]{s.getLabel()}));
            }

            public void onOpened(DataSourceEvent event) {
                ObserveMainUI mainUI;
                DataSource source = event.getSource();
                ObserveContext.this.getDataService().registerDataSource(source);
                ObserveContext.this.getValidationContext().setDataSource(source);
                ObserveConfig config = ObserveContext.this.getConfig();
                config.setMainStorageOpened(true);
                config.setMainStorageOpenedLocal(source instanceof H2DataSource);
                if (source instanceof H2DataSource) {
                    config.setLocalStorageExist(true);
                }
                if (ObserveCLAction.isUseJMX()) {
                    try {
                        ObjectName on = ObserveContext.this.createMBean(source);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("attach MBean " + on));
                        }
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        StatisticsService stats = new StatisticsService();
                        stats.setSessionFactory(((TopiaContextImplementor)source.getRootCtxt()).getHibernateFactory());
                        server.registerMBean(stats, on);
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not attach hibernate session to JMX...", (Throwable)e);
                    }
                }
                if ((mainUI = ObserveContext.this.getObserveMainUI()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("loading ui for storage " + source.getLabel() + ": " + mainUI.getName()));
                    }
                    DataContext dataContext = mainUI.getDataContext();
                    dataContext.setEnabled(true);
                    ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
                    treeHelper.cleanNavigationUI(mainUI);
                    try {
                        String[] openIds = ObserveContext.this.getDataService().getOpenIds(source);
                        mainUI.getDataContext().populateOpens(openIds);
                    }
                    catch (DataSourceException e) {
                        throw new RuntimeException(e);
                    }
                    treeHelper.loadNavigationUI(source, mainUI);
                    mainUI.setMode(ObserveUIMode.DB);
                    mainUI.getStatus().setStatus(I18n._((String)"observe.message.db.loaded", (Object[])new Object[]{source.getLabel()}));
                }
            }

            public void onClosing(DataSourceEvent event) {
                super.onClosing(event);
                DataSource source = event.getSource();
                ObserveContext.this.getDataService().unregisterDataSource(source);
                ObserveContext.this.getValidationContext().closeDataSource();
                ObserveMainUI mainUI = ObserveContext.this.getObserveMainUI();
                DataContext dataContext = ObserveContext.this.getDataContext();
                dataContext.setEnabled(false);
                dataContext.populateOpens(new String[0]);
                mainUI.getTreeHelper().cleanNavigationUI(mainUI);
                ObserveContext.this.getConfig().setMainStorageOpened(false);
            }

            public void onClosed(DataSourceEvent event) {
                ObserveMainUI mainUI;
                DataSource source = event.getSource();
                if (ObserveCLAction.isUseJMX()) {
                    try {
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        ObjectName on = ObserveContext.this.createMBean(source);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("dettach MBean " + on));
                        }
                        server.unregisterMBean(on);
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not dettach hibernate session from JMX...", (Throwable)e);
                    }
                }
                if ((mainUI = ObserveContext.this.getObserveMainUI()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dispose ui from storage " + source.getLabel() + ": " + mainUI.getName()));
                    }
                    mainUI.setMode(ObserveUIMode.NO_DB);
                    UIHelper.displayInfo(I18n._((String)"observe.message.db.closed", (Object[])new Object[]{source.getLabel()}));
                }
            }
        });
    }

    public void registerShareActions(ObserveMainUI ui) {
        ActionMap actionMap = ui.getRootPane().getActionMap();
        ACTION_MAP_ENTRY_DEF.setContextValue((JAXXContext)this, (Object)actionMap);
        this.registerMainAction(actionMap, new SelectOpenNodeUIAction(ui));
        this.registerMainAction(actionMap, new SelectNodeUIAction(ui));
        this.registerMainAction(actionMap, new GoUpUIAction(ui));
        this.registerMainAction(actionMap, new GoDownUIAction(ui));
        this.registerMainAction(actionMap, new ReOpenUIAction(ui));
        this.registerMainAction(actionMap, new CloseOpenUIAction(ui));
        this.registerMainAction(actionMap, new CloseAndCreateUIAction(ui));
        this.registerMainAction(actionMap, new CancelCreateUIAction(ui));
        this.registerMainAction(actionMap, new ResetEditUIAction(ui));
        this.registerMainAction(actionMap, new SaveEditUIAction(ui));
        this.registerMainAction(actionMap, new DeleteDataUIAction(ui));
        this.registerMainAction(actionMap, new DeleteReferentielUIAction(ui));
    }

    public void registerMainAction(ActionMap actionMap, AbstractUIAction action) {
        String actionId = action.getActionId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("register action " + actionId));
        }
        actionMap.put(actionId, action);
    }

    protected ObjectName createMBean(DataSource source) throws MalformedObjectNameException {
        Hashtable<String, String> tb = new Hashtable<String, String>();
        tb.put("type", "statistics");
        String name = source.getLabel();
        tb.put("sessionFactory", name.replaceAll(":", "_"));
        ObjectName on = new ObjectName("hibernate", tb);
        return on;
    }
}

