/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.impl.PGDataSource;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.ui.storage.RemoteUILauncher;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.sql.SQLException;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public enum ObstunaAdminAction {
    CREATE(I18n.n_((String)"observe.obstuna.action.create"), I18n.n_((String)"observe.obstuna.action.create.description"), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel())){

                @Override
                protected void init(StorageUI ui) {
                    StorageUIModel model = ui.getModel();
                    model.setCreationMode(CreationMode.IMPORT_REMOTE_STORAGE);
                    super.init(ui);
                }

                @Override
                protected void initTask(StorageUIModel model, PGInstall task) throws Exception {
                    PGDataSourceConfig importConfig = model.getCentralSourceModel().getPgConfig();
                    importConfig.setCanMigrate(false);
                    log.info((Object)("Use referentiel import data source " + importConfig.getLabel()));
                    model.getPgConfig().setCanMigrate(false);
                    super.initTask(model, task);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void createDb(PGInstall task) throws Exception {
                    log.info((Object)"Create db...");
                    task.dropDb();
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    log.info((Object)("Open [" + service.getLabel() + "] and create it."));
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    log.info((Object)"Apply security...");
                    task.applySecurity();
                }
            };
        }
    }
    ,
    UPDATE(I18n.n_((String)"observe.obstuna.action.update"), I18n.n_((String)"observe.obstuna.action.update.description"), VersionUtil.valueOf((String)"1.0")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel())){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void createDb(PGInstall task) throws Exception {
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    log.info((Object)("Open [" + service.getLabel() + "] and update it."));
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    log.info((Object)"Apply security...");
                    task.applySecurity();
                }
            };
        }
    }
    ,
    SECURITY(I18n.n_((String)"observe.obstuna.action.security"), I18n.n_((String)"observe.obstuna.action.security.description"), VersionUtil.valueOf((String)"1.4")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel())){

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    log.info((Object)"Apply security...");
                    task.applySecurity();
                }
            };
        }
    }
    ,
    DROP(I18n.n_((String)"observe.obstuna.action.drop"), I18n.n_((String)"observe.obstuna.action.drop.description"), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel())){

                @Override
                protected void createDb(PGInstall task) throws Exception {
                    log.info((Object)"Drop db...");
                    task.dropDb();
                }
            };
        }
    };

    private static Log log;
    private final String label;
    private final String description;
    private final Version requiredVersion;

    private ObstunaAdminAction(String label, String description, Version requiredVersion) {
        this.label = label;
        this.description = description;
        this.requiredVersion = requiredVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getRequiredVersion() {
        return this.requiredVersion;
    }

    public static ObstunaAdminAction valueOfIgnoreCase(String value) {
        for (ObstunaAdminAction step : ObstunaAdminAction.values()) {
            if (!step.name().equalsIgnoreCase(value)) continue;
            return step;
        }
        return null;
    }

    public abstract RemoteUILauncher newLauncher(JAXXContext var1, Window var2);

    static {
        log = LogFactory.getLog(ObstunaAdminAction.class);
    }
}

