/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.CaleeUI;
import fr.ird.observe.ui.content.data.CaptureFauneUI;
import fr.ird.observe.ui.content.data.CaptureThonUI;
import fr.ird.observe.ui.content.data.EchantillonFauneUI;
import fr.ird.observe.ui.content.data.EchantillonThonUI;
import fr.ird.observe.ui.content.data.EspeceFauneObserveeUI;
import fr.ird.observe.ui.content.data.EstimationBancObjetUI;
import fr.ird.observe.ui.content.data.EstimationBancUI;
import fr.ird.observe.ui.content.data.MareeUI;
import fr.ird.observe.ui.content.data.ObjetFlottantUI;
import fr.ird.observe.ui.content.data.OperationBaliseUI;
import fr.ird.observe.ui.content.data.ProgrammeUI;
import fr.ird.observe.ui.content.data.RejetThonUI;
import fr.ird.observe.ui.content.data.RouteUI;
import fr.ird.observe.ui.tree.ObserveTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.NavigationNodeRenderer;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractObserveTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected static final Log log = LogFactory.getLog(ObserveTreeCellRenderer.class);
    public static final List<Class<?>> CREATION_UI = Collections.unmodifiableList(Arrays.asList(MareeUI.class, RouteUI.class, ActiviteUI.class, ObjetFlottantUI.class, CaleeUI.class));
    protected DefaultTreeCellRenderer delegate;
    protected Color normalColor;
    protected Color openColor;
    protected Color redColor;

    public AbstractObserveTreeCellRenderer() {
        this.init(this);
    }

    public AbstractObserveTreeCellRenderer(DefaultTreeCellRenderer delegate) {
        this.init(delegate);
    }

    protected void init(DefaultTreeCellRenderer delegate) {
        this.normalColor = Color.LIGHT_GRAY;
        this.openColor = delegate.getForeground();
        this.redColor = Color.RED;
        this.delegate = delegate;
    }

    public void setIcon(NavigationTreeNode node) {
        Icon icon = this.getNavigationIcon(node);
        this.setDefaultIcons(icon);
    }

    public Icon getNavigationIcon(NavigationTreeNode node) {
        Icon icon = this.getNavigationIcon(node, null);
        return icon;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return null;
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        return null;
    }

    public Icon getNavigationIcon(NavigationTreeNode node, String suffix) {
        Icon icon = null;
        if (suffix == null) {
            suffix = "";
        }
        if (node != null) {
            String contextPath = node.getFullPath();
            if (contextPath.equals("$root/referentiel")) {
                icon = UIManager.getIcon("navigation.referentiel" + suffix);
            } else if (contextPath.startsWith("$root/referentiel/")) {
                icon = UIManager.getIcon("navigation.sub.referentiel" + suffix);
            }
            if (icon == null) {
                icon = UIManager.getIcon("navigation." + node.getInternalClass().getName() + suffix);
            }
        }
        return icon;
    }

    public void setDefaultIcons(Icon icon) {
        if (icon == null) {
            this.delegate.setOpenIcon(this.delegate.getDefaultOpenIcon());
            this.delegate.setClosedIcon(this.delegate.getDefaultClosedIcon());
            this.delegate.setLeafIcon(this.delegate.getDefaultLeafIcon());
        } else {
            this.delegate.setOpenIcon(icon);
            this.delegate.setClosedIcon(icon);
            this.delegate.setLeafIcon(icon);
        }
    }

    public String getText(NavigationTreeNode node) {
        if (node == null) {
            return null;
        }
        NavigationNodeRenderer renderer = node.getRenderer();
        String text = renderer.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("bean = " + node.getBean()));
            log.debug((Object)(text + " for node " + node.getFullPath()));
        }
        return text;
    }

    public Color getNavigationTextColor(NavigationModel<NavigationTreeNode> model, NavigationTreeNode node) {
        String contextPath = node.getFullPath();
        if (node.isRoot() || contextPath.startsWith("$root/referentiel") || contextPath.startsWith("$root/nodb")) {
            return this.openColor;
        }
        Class contentClass = node.getUIClass();
        if (ProgrammeUI.class.equals((Object)contentClass)) {
            Programme openProgramme;
            Programme c = (Programme)model.getBean((NavigationNode)node);
            Maree m = ObserveContext.getDataContext().getOpenMaree();
            Programme programme = openProgramme = m == null ? null : m.getProgramme();
            if (c != null && c.equals(openProgramme)) {
                return this.openColor;
            }
            return this.normalColor;
        }
        boolean nodeIsOpen = this.isOpenNode(model, node);
        if (!nodeIsOpen) {
            return this.normalColor;
        }
        if (CREATION_UI.contains(contentClass)) {
            try {
                TopiaEntity t = (TopiaEntity)model.getBean((NavigationNode)node);
                if (t.getTopiaId() == null) {
                    return this.redColor;
                }
            }
            catch (Exception e) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass.equals(OperationBaliseUI.class)) {
            ObjetFlottant c = (ObjetFlottant)model.getBean((NavigationNode)node);
            if (c.isBaliseLueEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (EstimationBancObjetUI.class.equals((Object)contentClass)) {
            ObjetFlottant c = (ObjetFlottant)model.getBean((NavigationNode)node);
            if (c.isEstimationBancObjetEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (EspeceFauneObserveeUI.class.equals((Object)contentClass)) {
            ObjetFlottant c = (ObjetFlottant)model.getBean((NavigationNode)node);
            if (c.isEspeceFauneObserveeEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (EstimationBancUI.class.equals((Object)contentClass)) {
            Calee c = (Calee)model.getBean((NavigationNode)node);
            if (c.isEstimationBancEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (CaptureThonUI.class.equals((Object)contentClass)) {
            Calee c = (Calee)model.getBean((NavigationNode)node);
            if (!c.hasCaptureThon()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (RejetThonUI.class.equals((Object)contentClass)) {
            Calee c = (Calee)model.getBean((NavigationNode)node);
            if (!c.hasRejetThon()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (EchantillonThonUI.class.equals((Object)contentClass)) {
            EchantillonThon c = (EchantillonThon)model.getBean((NavigationNode)node);
            if (c.isTailleThonEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (CaptureFauneUI.class.equals((Object)contentClass)) {
            Calee c = (Calee)model.getBean((NavigationNode)node);
            if (c.isCaptureFauneEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (EchantillonFauneUI.class.equals((Object)contentClass)) {
            EchantillonFaune c = (EchantillonFaune)model.getBean((NavigationNode)node);
            if (c.isTailleFauneEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        return this.openColor;
    }

    public boolean isOpenNode(NavigationModel<NavigationTreeNode> model, NavigationTreeNode node) {
        Object bean;
        String contextPath = node.getFullPath();
        if (node.isRoot() || contextPath.startsWith("$root/referentiel") || contextPath.startsWith("$root/nodb")) {
            return false;
        }
        boolean nodeIsOpen = false;
        NavigationTreeNode openableNode = this.getFirstOpenableNode(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("openable node " + Arrays.toString(openableNode.getPath()) + " for " + Arrays.toString(node.getPath())));
        }
        if (!((bean = model.getBean((NavigationNode)openableNode)) instanceof Openable) && (openableNode = openableNode.getParent()) != null) {
            bean = model.getBean((NavigationNode)openableNode);
        }
        if (bean instanceof Openable) {
            Openable openBean = (Openable)bean;
            nodeIsOpen = openBean.isOpen();
        }
        return nodeIsOpen;
    }

    public static NavigationTreeNode getNode(Object value) {
        NavigationTreeNode node = null;
        if (value instanceof NavigationTreeNode) {
            node = (NavigationTreeNode)value;
        }
        return node;
    }

    public NavigationTreeNode getFirstOpenableNode(NavigationTreeNode node) {
        if (Openable.class.isAssignableFrom(node.getInternalClass())) {
            return node;
        }
        if (Programme.class.isAssignableFrom(node.getInternalClass())) {
            return node;
        }
        NavigationTreeNode parentNode = node.getParent();
        if (parentNode != null) {
            return this.getFirstOpenableNode(parentNode);
        }
        return null;
    }

    protected Component getTreeCellRendererComponent0(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component r = this.equals(this.delegate) ? super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus) : this.delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return r;
    }
}

