/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.services.ObserveServiceHelper;
import fr.ird.observe.services.storage.ReplicationService;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.services.storage.StorageServiceFactory;
import fr.ird.observe.services.storage.constants.CreationMode;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.services.storage.event.StorageServiceAdapter;
import fr.ird.observe.services.storage.event.StorageServiceEvent;
import fr.ird.observe.services.storage.event.StorageServiceListener;
import fr.ird.observe.services.storage.impl.H2StorageConfig;
import fr.ird.observe.services.storage.impl.H2StorageService;
import fr.ird.observe.services.storage.impl.PGStorageConfig;
import fr.ird.observe.services.storage.impl.PGStorageService;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.StorageWizardLauncher;
import java.awt.Cursor;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

@DefaultApplicationContext.AutoLoad
public class StorageUIHandler {
    private static final Log log = LogFactory.getLog(StorageUIHandler.class);
    protected ReplicationService replicationService = ObserveServiceHelper.newReplicationService();

    public StorageService<?> newServiceFromModel(JAXXContext context, StorageUIModel model, boolean isMain, String localLabel, String remoteLabel) throws IOException {
        PGStorageService mainStorage = null;
        switch (model.getDbMode()) {
            case CREATE_LOCAL: 
            case USE_LOCAL: {
                H2StorageConfig h2Config = model.toH2StorageConfig(localLabel);
                H2StorageService h2Service = StorageServiceFactory.newService((H2StorageConfig)h2Config);
                h2Service.addStorageServiceListener((StorageServiceListener)new StorageServiceAdapter(){

                    public void onOpened(StorageServiceEvent event) {
                        H2StorageService s = (H2StorageService)event.getSource();
                        ObserveContext context = ObserveContext.get();
                        ((ObserveConfig)((Object)context.getContextValue(ObserveConfig.class))).setLocalStorageExist(true);
                        ((H2StorageConfig)s.getConfig()).setCreationMode(CreationMode.USE_LOCAL_STORAGE);
                    }
                });
                mainStorage = h2Service;
                break;
            }
            case USE_REMOTE: {
                PGStorageService pgservice;
                PGStorageConfig pgConfig = model.toPostgresStorageConfig(remoteLabel);
                mainStorage = pgservice = StorageServiceFactory.newService((PGStorageConfig)pgConfig);
            }
        }
        if (isMain) {
            ObserveContext.get().prepareMainStorage((StorageService<?>)mainStorage);
        }
        return mainStorage;
    }

    public void launchApply(StorageUI ui) {
        ui.setCursor(Cursor.getPredefinedCursor(3));
        try {
            StorageUIModel model = ui.getModel();
            if (model.isStoreRemoteConfig() && model.getDbMode() == DbMode.USE_REMOTE) {
                log.debug((Object)("store remote config from " + (Object)((Object)model)));
                this.storeRemoteConfig((JAXXContext)ui, model);
            }
            Runnable action = ui.getContextValue(Runnable.class, "apply");
            action.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ui.setCursor(Cursor.getDefaultCursor());
            ui.dispose();
        }
    }

    public void launchCancel(StorageUI ui) {
        try {
            Runnable action = ui.getContextValue(Runnable.class, "cancel");
            action.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ui.dispose();
        }
    }

    public void doChangeStorage(JAXXContext context, StorageUIModel model) {
        File f;
        boolean destroyLocalBase;
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        boolean bl = destroyLocalBase = config.isLocalStorageExist() && model.getDbMode() == DbMode.CREATE_LOCAL && model.getCreationMode() != CreationMode.USE_LOCAL_STORAGE;
        if (log.isDebugEnabled()) {
            log.debug((Object)(">>> should destroy local db ? " + destroyLocalBase));
        }
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        StorageService<?> mainStorage = dataContext.getStorage();
        H2StorageService localStorage = null;
        if (mainStorage instanceof H2StorageService) {
            localStorage = (H2StorageService)mainStorage;
        }
        if ((destroyLocalBase || model.isDoBackup()) && localStorage == null) {
            try {
                H2StorageConfig localConfig = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
                localStorage = StorageServiceFactory.newService((H2StorageConfig)localConfig);
                localStorage.doOpen();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (model.isDoBackup()) {
            f = model.getBackupFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> do backup with " + localStorage + " in " + f));
            }
            try {
                this.backupLocalDatabase((StorageService<?>)localStorage, f);
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (destroyLocalBase) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> destroy local db " + localStorage));
            }
            try {
                localStorage.doClose(true);
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (mainStorage != null && mainStorage.isOpen()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> close main storage " + mainStorage));
                }
                mainStorage.doClose(false);
            }
            catch (StorageServiceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
        if (localStorage != null && localStorage.isOpen()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> close local storage " + localStorage));
                }
                localStorage.doClose(false);
            }
            catch (StorageServiceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
        localStorage = null;
        try {
            mainStorage = this.newServiceFromModel(context, model, true, "observe.storage.label.local", "observe.storage.label.remote");
            mainStorage.doOpen();
            if (log.isInfoEnabled()) {
                log.info((Object)(">>> main storage opened " + mainStorage.getLabel()));
            }
            if (model.getDbMode() == DbMode.CREATE_LOCAL && model.getCreationMode() == CreationMode.IMPORT_REMOTE_STORAGE) {
                f = config.getInitialDbDump();
                if (f.exists() && !f.delete()) {
                    throw new IllegalStateException("could not delete " + f);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)(">>> create initial dump with " + localStorage + " in " + f));
                }
                try {
                    this.backupLocalDatabase(mainStorage, f);
                    config.setInitialDumpExist(true);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void storeRemoteConfig(JAXXContext context, StorageUIModel model) {
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        PGStorageConfig remoteConfig = model.toPostgresStorageConfig("");
        config.fromStorageConfig(remoteConfig);
    }

    public String getDefaultBackupFilename() {
        return String.format("obstuna-local-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupLocalDatabase(StorageService<?> service, File dst) {
        if (dst == null) {
            throw new IllegalArgumentException("file where to backup can not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)dst);
        }
        if (service instanceof H2StorageService) {
            try {
                service.storeDB(dst);
            }
            catch (StorageServiceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        } else {
            ObserveConfig config = ObserveContext.getConfig();
            DecoratorService decoratorService = this.getDecoratorService();
            StorageService tempStorage = null;
            try {
                tempStorage = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)config, (String)I18n._((String)"observe.storage.label.backup"), (String)("tmpBackup_" + dst.getName()));
                tempStorage.doOpen();
                this.replicationService.replicateReferentiel(decoratorService, service, tempStorage);
                this.replicationService.replicateAllData(decoratorService, service, tempStorage);
                tempStorage.storeDB(dst);
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
            }
            finally {
                block20: {
                    if (tempStorage != null) {
                        try {
                            tempStorage.doClose(true);
                        }
                        catch (StorageServiceException e) {
                            ErrorDialogUI.showError((Exception)((Object)e));
                            if (!log.isErrorEnabled()) break block20;
                            log.error((Object)e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupLocalDatabase(StorageService<?> service, File dst, Set<Maree> marees) {
        if (marees == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"will export all datas.");
            }
            this.backupLocalDatabase(service, dst);
            return;
        }
        if (dst == null) {
            throw new IllegalArgumentException("file where to backup can not be null");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("will export " + marees.size() + " marees to " + dst));
        }
        if (log.isDebugEnabled()) {
            log.debug(marees);
        }
        ObserveConfig config = ObserveContext.getConfig();
        String[] mareeIds = new String[marees.size()];
        int index = 0;
        for (Maree m : marees) {
            mareeIds[index++] = m.getTopiaId();
        }
        DecoratorService decoratorService = this.getDecoratorService();
        StorageService tempStorage = null;
        try {
            tempStorage = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)config, (String)I18n._((String)"observe.storage.label.backup"), (String)("tmpBackup_" + dst.getName()));
            tempStorage.doOpen();
            this.replicationService.replicateReferentiel(decoratorService, service, tempStorage);
            this.replicationService.replicateData(decoratorService, service, tempStorage, mareeIds);
            tempStorage.storeDB(dst);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            block20: {
                if (tempStorage != null) {
                    try {
                        tempStorage.doClose(true);
                    }
                    catch (StorageServiceException e) {
                        ErrorDialogUI.showError((Exception)((Object)e));
                        if (!log.isErrorEnabled()) break block20;
                        log.error((Object)e);
                    }
                }
            }
        }
    }

    public void obtainRemoteConnexion(JAXXContext rootContext, Window mainUI, final StorageUIModel model) {
        if (mainUI == null) {
            mainUI = ObserveContext.getObserveMainUI();
        }
        StorageWizardLauncher launcher = new StorageWizardLauncher(rootContext, mainUI, model, I18n._((String)"observe.title.connect.remoteDB")){

            @Override
            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                model2.setDbMode(DbMode.USE_REMOTE);
                model2.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE, StorageStep.BACKUP, StorageStep.CONFIRM));
                model2.setSteps(new StorageStep[]{StorageStep.CONFIG});
            }

            @Override
            protected void doCancel(StorageUI ui) {
                super.doCancel(ui);
                log.info((Object)ui.getName());
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public void obtainLocalConnexion(JAXXContext rootContext, Window mainUI, final StorageUIModel model) {
        if (mainUI == null) {
            mainUI = ObserveContext.getObserveMainUI();
        }
        StorageWizardLauncher launcher = new StorageWizardLauncher(rootContext, mainUI, model, I18n._((String)"observe.title.connect.localDB")){

            @Override
            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                model2.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE, StorageStep.BACKUP, StorageStep.SELECT_DATA, StorageStep.CONFIRM));
                model2.updateUniverse();
            }

            @Override
            protected void doCancel(StorageUI ui) {
                super.doCancel(ui);
                log.info((Object)ui.getName());
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public boolean testRemote(JAXXContext context, StorageUIModel model) {
        boolean result = model.getPgConfig().canConnect();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result : " + result));
        }
        model.firePgConfigChanged("connexionStatus", null, null);
        return result;
    }

    public String computeReport(StorageUIModel model, StorageStep step) {
        DbMode dbMode;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Build report from step " + (Object)((Object)step)));
        }
        if ((dbMode = model.getDbMode()) == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(512);
        if (model.isBackupAction()) {
            this.computeBackupReport(model, sb);
        } else {
            switch (model.getDbMode()) {
                case USE_LOCAL: {
                    this.computeConnectLocalReport(model, sb);
                    break;
                }
                case CREATE_LOCAL: {
                    this.computeCreateLocalReport(model, sb);
                    break;
                }
                case USE_REMOTE: {
                    this.computeConnectRemoteReport(model, sb);
                }
            }
        }
        return sb.toString();
    }

    protected DecoratorService getDecoratorService() {
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        return decoratorService;
    }

    protected void computeCreateLocalReport(StorageUIModel model, StringBuilder sb) {
        CreationMode creationMode = model.getCreationMode();
        if (creationMode == null) {
            return;
        }
        if (model.isDoBackup()) {
            this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.backup.local"));
            this.addTag("hr", sb, "");
            this.addTag("h3", sb, I18n._((String)"observe.storage.report.selected.backup.file"));
            this.addOpenTag("ul", sb);
            this.addTag("li", sb, model.getBackupFile().getAbsolutePath());
            this.addCloseTag("ul", sb);
        }
        this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.create.local"));
        this.addTag("hr", sb, "");
        switch (creationMode) {
            case IMPORT_INTERNAL_DUMP: {
                this.addTag("h3", sb, I18n._((String)"observe.storage.report.action.import.internal"));
                this.addOpenTag("ul", sb);
                this.addTag("li", sb, model.getConfig().getInitialDbDump().getAbsoluteFile().getAbsolutePath());
                this.addCloseTag("ul", sb);
                break;
            }
            case IMPORT_EXTERNAL_DUMP: {
                this.addTag("h3", sb, I18n._((String)"observe.storage.report.action.import.backup"));
                this.addOpenTag("ul", sb);
                this.addTag("li", sb, model.getDumpFile().getAbsolutePath());
                this.addCloseTag("ul", sb);
                break;
            }
            case IMPORT_REMOTE_STORAGE: {
                this.addTag("h3", sb, I18n._((String)"observe.storage.report.action.import.remote.referentiel"));
                this.addTag("pre", sb, model.getPgConfig().toString());
                break;
            }
            case EMPTY: {
                break;
            }
            case USE_LOCAL_STORAGE: {
                break;
            }
        }
        this.computeCanMigrateAction(model, sb);
    }

    protected void computeConnectLocalReport(StorageUIModel model, StringBuilder sb) {
        this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.connect.local"));
        this.addTag("hr", sb, "");
        this.addTag("h3", sb, I18n._((String)"observe.storage.report.selected.localStorageFile"));
        this.addOpenTag("ul", sb);
        this.addTag("li", sb, model.getH2Config().getDataDirectory().getAbsolutePath());
        this.addCloseTag("ul", sb);
        this.computeCanMigrateAction(model, sb);
    }

    protected void computeConnectRemoteReport(StorageUIModel model, StringBuilder sb) {
        this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.connect.remote"));
        this.addTag("hr", sb, "");
        this.addTag("h3", sb, I18n._((String)"observe.storage.report.selected.remoteStorage"));
        this.addTag("pre", sb, model.getPgConfig().toString());
        this.computeCanMigrateAction(model, sb);
    }

    protected void computeBackupReport(StorageUIModel model, StringBuilder sb) {
        if (model.isLocal()) {
            this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.backup.local"));
        }
        if (model.isRemote()) {
            this.addTag("h2", sb, I18n._((String)"observe.storage.report.action.backup.remote"));
        }
        this.addTag("hr", sb, "");
        this.addTag("h3", sb, I18n._((String)"observe.storage.report.selected.backup.file"));
        this.addOpenTag("ul", sb);
        this.addTag("li", sb, model.getBackupFile().getAbsolutePath());
        this.addCloseTag("ul", sb);
        if (!model.isUseSelectData() || model.getSelectDataModel() == null) {
            return;
        }
        SelectDataModel dataModel = model.getSelectDataModel();
        Set selectedData = dataModel.getSelectedData();
        this.addTag("h3", sb, I18n._((String)"observe.storage.report.selected.data.to.export"));
        this.addOpenTag("ul", sb);
        if (dataModel.isDataEmpty()) {
            this.addTag("li", sb, I18n._((String)"observe.storage.report.selected.no.data"));
        } else if (dataModel.isDataFull()) {
            this.addTag("li", sb, I18n._((String)"observe.storage.report.selected.all.data", (Object[])new Object[]{selectedData.size()}));
        } else {
            this.addOpenTag("li", sb);
            sb.append(I18n._((String)"observe.storage.report.selected.data", (Object[])new Object[]{selectedData.size()}));
            this.addOpenTag("ul", sb);
            Decorator decorator = this.getDecoratorService().getDecorator(Maree.class);
            for (Maree m : selectedData) {
                this.addTag("li", sb, decorator.toString((Object)m));
            }
            this.addCloseTag("li", sb);
            this.addCloseTag("ul", sb);
        }
        this.addTag("li", sb, I18n._((String)"observe.storage.report.selected.data.referentiel"));
        this.addCloseTag("ul", sb);
    }

    protected void computeCanMigrateAction(StorageUIModel model, StringBuilder sb) {
        this.addTag("h3", sb, I18n._((String)"observe.storage.report.action.migrate"));
        this.addOpenTag("ul", sb);
        if (model.isCanMigrate()) {
            Version version = model.getDbVersion();
            this.addTag("li", sb, I18n._((String)"observe.storage.report.can.migrate", (Object[])new Object[]{version}));
        } else {
            this.addTag("li", sb, I18n._((String)"observe.storage.report.can.not.migrate"));
        }
        this.addCloseTag("ul", sb);
    }

    protected void addTag(String tag, StringBuilder sb, String message) {
        sb.append('<').append(tag).append('>');
        sb.append(message);
        sb.append("</").append(tag).append('>');
    }

    protected void addOpenTag(String tag, StringBuilder sb) {
        sb.append('<').append(tag).append('>');
    }

    protected void addCloseTag(String tag, StringBuilder sb) {
        sb.append("</").append(tag).append('>');
    }
}

