/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveAction;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.services.storage.StorageServiceFactory;
import fr.ird.observe.services.storage.constants.CommonStorageConfigParam;
import fr.ird.observe.services.storage.constants.CreationMode;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.services.storage.impl.H2StorageConfig;
import fr.ird.observe.services.storage.impl.H2StorageConfigParam;
import fr.ird.observe.services.storage.impl.PGStorageConfig;
import fr.ird.observe.services.storage.impl.PGStorageConfigParam;
import fr.ird.observe.ui.UIHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class ObserveConfig
extends ApplicationConfig
implements IObserveConfig {
    private static Log log = LogFactory.getLog(ObserveConfig.class);
    protected static File observeUserDirectory;
    protected boolean displayMainUI = true;
    protected boolean localStorageExist;
    protected boolean initialDumpExist;
    protected boolean mainStorageOpened;
    protected Boolean mainStorageOpenedLocal;
    protected boolean canUseUI = true;
    protected boolean adjusting;
    protected final PropertyChangeListener saveAction = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ObserveConfig.this.adjusting) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skip save while adjusting");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving configuration fired by property [" + evt.getPropertyName() + "] at " + new Date()));
            }
            ObserveConfig.this.saveForUser();
        }
    };
    protected String copyrightText;

    public static File getObserveUserDirectory() {
        if (observeUserDirectory == null) {
            observeUserDirectory = new File(new File(ObserveConfig.getUserHome()), ".observe");
        }
        return observeUserDirectory;
    }

    public static String getObserveUserDirectory(String path) {
        File file = new File(ObserveConfig.getObserveUserDirectory(), path);
        return file.getAbsolutePath();
    }

    public ObserveConfig() {
        this.setConfigFileName(ObserveConfigOption.CONFIG_FILE.defaultValue);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/observe.properties");
        Properties p = new Properties();
        try {
            p.load(stream);
            for (Object k : p.keySet()) {
                String key = String.valueOf(k);
                Object value = p.get(k);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("install property [" + k + "] : " + value));
                }
                this.setDefaultOption(key, String.valueOf(value));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (ObserveConfigOption o : ObserveConfigOption.values()) {
            this.setDefaultOption(o.key, o.defaultValue);
        }
        String applicationVersion = this.getOption("application.version");
        String sVersion = VersionUtil.removeSnapshot((String)applicationVersion);
        Version version = VersionUtil.valueOf((String)sVersion);
        this.setDefaultOption("version", version.getVersion());
        Version dbVersion = VersionUtil.valueOf((String)ObserveDAOHelper.getModelVersion());
        this.setDefaultOption("db.version", dbVersion.getVersion());
        for (Action a : Action.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
    }

    protected void installPropertyChangeListeners() {
        this.adjusting = true;
        for (ObserveConfigOption option : ObserveConfigOption.values()) {
            String propertyKey = option.getPropertyKey();
            if (propertyKey == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("register action listener for property " + propertyKey));
            }
            this.addPropertyChangeListener(propertyKey, this.saveAction);
        }
        this.adjusting = false;
    }

    public String getCopyrightText() {
        if (this.copyrightText == null) {
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            this.copyrightText = "Version " + this.getVersion() + " IRD @ 2008-" + year;
        }
        return this.copyrightText;
    }

    public Version getVersion() {
        Version option = (Version)this.getOption(Version.class, "version");
        return option;
    }

    public Version getDbVersion() {
        Version option = (Version)this.getOption(Version.class, "db.version");
        return option;
    }

    public boolean isAutoPopupNumberEditor() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR.key);
        return result != null && result != false;
    }

    public boolean isShowNumberEditorButton() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON.key);
        return result != null && result != false;
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public File getLocalDBDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.DB_DIRECTORY.key);
        return result;
    }

    public File getResourcesDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.RESOURCES_DIRECTORY.key);
        return result;
    }

    public File getI18nDirectory() {
        File result = new File(this.getResourcesDirectory(), "i18n-" + this.getVersion());
        return result;
    }

    public File getInitialDbDump() {
        File result = this.getOptionAsFile(ObserveConfigOption.INITIAL_DB_DUMP.key);
        return result;
    }

    public File getBackupDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.BACKUP_DIRECTORY.key);
        return result;
    }

    public File getReportDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.REPORT_DIRECTORY.key);
        return result;
    }

    public File getTmpDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.TMP_DIRECTORY.key);
        return result;
    }

    public String getH2Login() {
        String result = this.getOption(ObserveConfigOption.H2_LOGIN.key);
        return result;
    }

    public char[] getH2Password() {
        String result = this.getOption(ObserveConfigOption.H2_PASSWORD.key);
        char[] r = result.toCharArray();
        return r;
    }

    public String getObstunaUrl() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_URL.key);
        return result;
    }

    public String getObstunaLogin() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_LOGIN.key);
        return result;
    }

    public char[] getObstunaPassword() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_PASSWORD.key);
        char[] r = result.toCharArray();
        return r;
    }

    public boolean isObstunaUseSsl() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.OBSTUNA_USE_SSL_CERT.key);
        return result != null && result != false;
    }

    public File getObstunaSslCert() {
        File result = this.getOptionAsFile(ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE.key);
        return result;
    }

    public DbMode getDefaultDbMode() {
        DbMode result = (DbMode)this.getOption(DbMode.class, ObserveConfigOption.DEFAULT_DB_MODE.key);
        return result;
    }

    public CreationMode getDefaultCreationMode() {
        CreationMode result = (CreationMode)this.getOption(CreationMode.class, ObserveConfigOption.DEFAULT_CREATION_MODE.key);
        return result;
    }

    public int getDefaultGpsMaxDelay() {
        Integer i = this.getOptionAsInt(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY.key);
        return i;
    }

    public float getDefaultGpsMaxSpeed() {
        double i = this.getOptionAsDouble(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED.key);
        return (float)i;
    }

    public boolean isChangeSynchroSrc() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.CHANGE_SYNCHRO_SRC.key);
        return result;
    }

    public boolean isDisplaySynchroResume() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.DISPLAY_SYNCHRO_RESUME.key);
        return result;
    }

    public boolean isStoreRemoteStorage() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.STORE_REMOTE_STORAGE.key);
        return result;
    }

    public boolean isCanGenerateEmptyDb() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.CAN_GENERATE_EMPTY_DB.key);
        return result;
    }

    public boolean isCanMigrateObstuna() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.OBSTUNA_CAN_MIGRATE.key);
        return result != null && result != false;
    }

    public boolean isCanMigrateH2() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.H2_CAN_MIGRATE.key);
        return result != null && result != false;
    }

    public boolean isH2ReferentielEditable() {
        Boolean result = this.getOptionAsBoolean(ObserveConfigOption.H2_REFERENTIEL_EDITABLE.key);
        return result != null && result != false;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, ObserveConfigOption.LOCALE.key);
        return result;
    }

    public Locale getDbLocale() {
        Locale result = (Locale)this.getOption(Locale.class, ObserveConfigOption.DB_LOCALE.key);
        return result;
    }

    public int getObservationFauneAssociee() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_FAUNE_ASSOCIEE.key);
        return value;
    }

    public int getObservationRejetsThons() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_REJETS_THONS.key);
        return value;
    }

    public int getObservationMensurations() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_MENSURATIONS.key);
        return value;
    }

    public int getObservationObjetFlottant() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_OBJET_FLOTTANT.key);
        return value;
    }

    public int getObservationActivitesDetaillees() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_ACTIVITES_DETAILLEES.key);
        return value;
    }

    public int getObservationMammiferes() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_MAMMIFERES.key);
        return value;
    }

    public int getObservationOiseaux() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_OISEAUX.key);
        return value;
    }

    public int getObservationGleure() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBSERVATION_GLEURE.key);
        return value;
    }

    public boolean isDisplayMainUI() {
        return this.displayMainUI;
    }

    public boolean isCanUseUI() {
        return this.canUseUI;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isInitialDumpExist() {
        return this.initialDumpExist;
    }

    public boolean isMainStorageOpened() {
        return this.mainStorageOpened;
    }

    public Boolean getMainStorageOpenedLocal() {
        return this.mainStorageOpenedLocal;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setOption(String key, String value) {
        if (key.equals("adjusting")) {
            this.setAdjusting(Boolean.valueOf(value));
            return;
        }
        super.setOption(key, value);
    }

    public void setLocalStorageExist(boolean newValue) {
        this.localStorageExist = newValue;
        this.firePropertyChange("localStorageExist", null, newValue);
    }

    public void setInitialDumpExist(boolean newValue) {
        this.initialDumpExist = newValue;
        this.firePropertyChange("initialDumpExist", null, newValue);
    }

    public void setMainStorageOpened(boolean newValue) {
        this.mainStorageOpened = newValue;
        if (!newValue) {
            this.setMainStorageOpenedLocal(null);
        }
        this.firePropertyChange("mainStorageOpened", null, newValue);
    }

    public void setAdjusting(boolean newvalue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("changing adjusting to " + newvalue));
        }
        boolean oldValue = this.adjusting;
        this.adjusting = newvalue;
        this.firePropertyChange("adjusting", oldValue, newvalue);
    }

    public void setMainStorageOpenedLocal(Boolean newValue) {
        this.mainStorageOpenedLocal = newValue;
        this.firePropertyChange("mainStorageOpenedLocal", null, newValue);
    }

    public void setDisplayMainUI(boolean b) {
        this.displayMainUI = b;
    }

    public void setCanUseUI(boolean canUseUI) {
        this.canUseUI = canUseUI;
        if (!canUseUI) {
            this.setDisplayMainUI(false);
        }
    }

    public void saveForUser() {
        this.saveForUser(new String[]{ObserveConfigOption.OBSTUNA_PASSWORD.key, ObserveConfigOption.H2_PASSWORD.key, ObserveConfigOption.OBSTUNA_CAN_MIGRATE.key, ObserveConfigOption.H2_REFERENTIEL_EDITABLE.key});
    }

    public void fromStorageConfig(H2StorageConfig config) {
    }

    public void fromStorageConfig(PGStorageConfig config) {
        this.setOption(ObserveConfigOption.OBSTUNA_URL.key, config.getUrl());
        this.setOption(ObserveConfigOption.OBSTUNA_LOGIN.key, config.getLogin());
        this.setOption(ObserveConfigOption.OBSTUNA_PASSWORD.key, new String(config.getPassword()));
        boolean useSsl = config.isUseSsl();
        this.setOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT, useSsl);
        if (useSsl) {
            this.setOption(ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE, (Object)config.getSslCertificatFile().getAbsolutePath());
        } else {
            this.setOption(ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE.key, "");
        }
        this.saveForUser();
    }

    public H2StorageConfig toH2StorageConfig(String label) {
        H2StorageConfig result = StorageServiceFactory.newH2Config((String)label, (Object[])new Object[]{CommonStorageConfigParam.LOGIN, this.getH2Login(), CommonStorageConfigParam.PASSWORD, this.getH2Password(), H2StorageConfigParam.DIRECTORY, this.getLocalDBDirectory(), H2StorageConfigParam.REFERENTIEL_EDITABLE, this.isH2ReferentielEditable(), CommonStorageConfigParam.CAN_MIGRATE, this.isCanMigrateH2()});
        return result;
    }

    public PGStorageConfig toPostgresStorageConfig(String label) {
        PGStorageConfig result = StorageServiceFactory.newPGConfig((String)label, (Object[])new Object[]{PGStorageConfigParam.URL, this.getObstunaUrl(), CommonStorageConfigParam.LOGIN, this.getObstunaLogin(), CommonStorageConfigParam.PASSWORD, this.getObstunaPassword(), PGStorageConfigParam.USE_SSL, this.isObstunaUseSsl(), PGStorageConfigParam.SSL_CERTIFICAT_FILE, this.getObstunaSslCert(), CommonStorageConfigParam.CAN_MIGRATE, this.isCanMigrateObstuna()});
        return result;
    }

    public void removeJaxxPropertyChangeListener() {
        String[] propertyNames;
        PropertyChangeListener[] toRemove;
        ArrayList<String> tmp = new ArrayList<String>();
        for (ObserveConfigOption option : ObserveConfigOption.values()) {
            String propertyName = option.getPropertyKey();
            if (propertyName == null) continue;
            tmp.add(propertyName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("property names to seek for options : " + tmp));
        }
        if ((toRemove = UIHelper.findJaxxPropertyChangeListener((String[])(propertyNames = tmp.toArray(new String[tmp.size()])), (PropertyChangeListener[])this.getPropertyChangeListeners())) == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    protected void createDirectoriesIfNecessary(ObserveConfigOption ... options) throws IOException {
        for (ObserveConfigOption option : options) {
            File dir = this.getOptionAsFile(option.key);
            this.createDirectoryIfNecessary(dir);
        }
    }

    protected void createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists()) {
            boolean b;
            if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"observe.init.create.directory", (Object[])new Object[]{dir}));
            }
            if (!(b = dir.mkdirs())) {
                throw new IOException(I18n._((String)"observe.error.can.not.create.directory", (Object[])new Object[]{dir}));
            }
        }
    }

    protected void createParentDirectoriesIfNecessary(ObserveConfigOption ... options) throws IOException {
        for (ObserveConfigOption option : options) {
            File dir = this.getOptionAsFile(option.key).getParentFile();
            this.createDirectoryIfNecessary(dir);
        }
    }

    public void setOption(ObserveConfigOption option, Object newValue) {
        String propertyName;
        String oldValue = this.getOption(option.key);
        String value = String.valueOf(newValue);
        this.setOption(option.key, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("set option " + option.key + " value : " + value));
        }
        if ((propertyName = option.getPropertyKey()) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("fires config change from option " + option.key));
            }
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void prepareDirectories() throws IOException {
        File dataDirectory = ObserveConfig.getObserveUserDirectory();
        FileUtil.setCurrentDirectory((File)dataDirectory);
        this.createDirectoryIfNecessary(dataDirectory);
        this.createParentDirectoriesIfNecessary(ObserveConfigOption.DB_DIRECTORY, ObserveConfigOption.INITIAL_DB_DUMP);
        this.createDirectoriesIfNecessary(ObserveConfigOption.BACKUP_DIRECTORY, ObserveConfigOption.REPORT_DIRECTORY, ObserveConfigOption.TMP_DIRECTORY, ObserveConfigOption.RESOURCES_DIRECTORY);
        FileUtil.deleteRecursively((File)this.getTmpDirectory());
    }

    public static enum Action {
        HELP(I18n._((String)"observe.action.commandline.help"), ObserveAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(I18n._((String)"observe.action.commandline.help.ui"), ObserveAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(I18n._((String)"observe.action.commandline.disable.main.ui"), ObserveAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(I18n._((String)"observe.action.commandline.configure.ui"), ObserveAction.class.getName() + "#configure", "--configure"),
        SYNCHRO_UI(I18n._((String)"observe.action.commandline.launch.synchro"), ObserveAction.class.getName() + "#launchSynchroUI", "-s", "--synchro-ui"),
        VALIDATE_DATA_UI(I18n._((String)"observe.action.commandline.launch.validation"), ObserveAction.class.getName() + "#launchValidationUI", "-v", "--validation-ui"),
        CHANGE_STORAGE_UI(I18n._((String)"observe.action.commandline.change.storage"), ObserveAction.class.getName() + "#launchStorageUI", "-c", "--change-storage-ui"),
        CREATE_PG(I18n._((String)"observe.action.commandline.create.pg"), ObserveAction.class.getName() + "#launchCreatePG", "--create-pg"),
        UPDATE_PG(I18n._((String)"observe.action.commandline.update.pg"), ObserveAction.class.getName() + "#launchUpdatePG", "--update-pg"),
        UPDATE_PG_UI(I18n._((String)"observe.action.commandline.update.pg.ui"), ObserveAction.class.getName() + "#launchUpdatePGWithUI", "--update-pg-ui");

        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    public static enum Step {
        AfterInit,
        BeforeExit;

    }
}

