/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.storage.CommonStorageConfigParam;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceAdapter;
import fr.ird.observe.storage.StorageServiceEvent;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.StorageServiceListener;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageConfigParam;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationAction;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class SynchroOperationAction
extends WizardOperationAction<SynchroStep, SynchroUIModel> {
    private static final Log log = LogFactory.getLog(SynchroOperationAction.class);
    JAXXContext context;
    protected final StorageServiceListener serviceLogger = new StorageServiceAdapter(){

        public void onNewMessage(StorageServiceEvent event) {
            StorageService service = event.getSource();
            if (event.getMessageLevel() == StorageServiceEvent.MessageLevel.INFO) {
                SynchroOperationAction.this.sendMessage(service.getShortLabel() + " : " + event.getMessage());
            }
        }
    };

    public SynchroOperationAction(SynchroStep operation) {
        super((WizardOperationStep)operation);
    }

    public void start(JAXXContext context) {
        ObserveContext.getObserveMainUI().setBusy(true);
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.start", (Object[])new Object[]{new Date()}));
        this.context = context;
        this.execute();
    }

    protected SynchroUIModel getModel() {
        SynchroUIModel model = (SynchroUIModel)((Object)this.context.getContextValue(SynchroUIModel.class));
        return model;
    }

    protected JAXXContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        try {
            super.done();
        }
        finally {
            ObserveContext.getObserveMainUI().setBusy(false);
        }
    }

    public WizardOperationState onCancel(SynchroUIModel model, Exception e) {
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.canceled"));
        return WizardOperationState.CANCELED;
    }

    public WizardOperationState onError(SynchroUIModel model, Exception e) {
        this.setError(e);
        log.error((Object)e.getMessage(), (Throwable)e);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.failed"));
        return WizardOperationState.FAILED;
    }

    public void copyTo(SynchroOperationAction newAction) {
    }

    protected StorageService<?> createLocalService(StorageUIModel model, StorageService<?> previousService) throws Exception {
        if (model.isLocalStorageExist() && model.getDbMode() == DbMode.CREATE_LOCAL && model.getCreationMode() != CreationMode.USE_LOCAL_STORAGE) {
            this.sendMessage(I18n._((String)"observe.message.synchro.destroy.local.db"));
            log.debug((Object)("destroy previous local database (try to use " + previousService + ")"));
            StorageService<?> localService = null;
            if (previousService != null && previousService instanceof H2StorageService && previousService.isOpen()) {
                localService = previousService;
            } else {
                localService = ObserveContext.get().newLocalStorageService();
                localService.addStorageServiceListener(this.serviceLogger);
                localService.doOpen();
            }
            localService.doClose(true);
            localService.removeStorageServiceListener(this.serviceLogger);
            ObserveConfig config = ObserveContext.getConfig();
            config.setLocalStorageExist(false);
        }
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        if (previousService != null && previousService instanceof H2StorageService && model.getDbMode() == DbMode.CREATE_LOCAL && previousService.isOpen()) {
            previousService.doClose(false);
            previousService.removeStorageServiceListener(this.serviceLogger);
        }
        StorageService<?> service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected StorageService<?> createReferentielService(StorageUIModel model) throws IOException {
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        StorageService<?> service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected StorageService<?> createSynchroService() throws IOException {
        ObserveConfig mainConfig = ObserveContext.getConfig();
        H2StorageConfig conf = StorageServiceFactory.newH2Config((String)I18n.n_((String)"observe.storage.label.synchro"), (Object[])new Object[]{CommonStorageConfigParam.LOGIN, "sa", CommonStorageConfigParam.PASSWORD, "sa".toCharArray(), H2StorageConfigParam.CREATION_MODE, CreationMode.EMPTY, H2StorageConfigParam.DIRECTORY, new File(mainConfig.getTmpDirectory(), "synchrodb_" + System.nanoTime())});
        H2StorageService service = StorageServiceFactory.newService((H2StorageConfig)conf);
        ObserveContext.get().prepareMainStorage((StorageService<?>)service);
        ((H2StorageConfig)service.getConfig()).setUseCache(false);
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected void openService(StorageService<?> service) throws StorageServiceException {
        if (!service.isOpen()) {
            service.doOpen();
        }
    }
}

