/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.ReferentielLocaleEnum;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.StringUtil;

public class ObserveMain
implements Runnable {
    private static Log log = LogFactory.getLog(ObserveMain.class);
    static boolean reload;
    static Thread mainThread;
    static final Object lock;
    protected String[] args;

    public ObserveMain(String[] args) {
        this.args = args;
    }

    public static boolean isReload() {
        return reload;
    }

    public static synchronized void setReload(boolean reload) {
        ObserveMain.reload = reload;
        if (reload && mainThread != null) {
            ObserveMain.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock() {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        ObserveMain target = new ObserveMain(args);
        mainThread = new Thread((Runnable)target, "ObServeMain");
        mainThread.start();
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
                return;
            }
        }
        catch (InterruptedException e) {
            if (!log.isErrorEnabled()) return;
            log.error((Object)(mainThread + " was interrupted for reason " + e.getMessage()), (Throwable)e);
            return;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(mainThread + " was stopped..."));
            }
            if (ObserveMain.isReload()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will reload application");
                }
                try {
                    ObserveContext.get().close();
                    I18n.close();
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("An error occurs while closing application : " + e.getMessage()), (Throwable)e);
                    }
                }
                finally {
                    mainThread = null;
                    reload = false;
                    ObserveMain.main(args);
                }
            }
        }
    }

    protected ObserveContext init(boolean initLocalSotrage, String ... args) throws Exception {
        long t0 = System.nanoTime();
        ObserveContext context = ObserveContext.init();
        ObserveConfig config = ObserveContext.getConfig();
        config.parse(args);
        config.installPropertyChangeListeners();
        File directory = config.getResourcesDirectory();
        File i18nDirectory = new File(directory, "i18n");
        UserI18nInitializer i18nInitializer = new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("observe"));
        I18n.setInitializer((I18nInitializer)i18nInitializer);
        long t00 = System.nanoTime();
        Locale locale = config.getLocale();
        I18n.init((Locale)locale);
        log.info((Object)("i18n language : " + locale));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        config.prepareDirectories();
        Locale dbLocale = config.getDbLocale();
        ReferentielLocaleEnum localeEnum = ReferentielLocaleEnum.valueOf((Locale)dbLocale);
        ObserveDecoratorProvider provider = new ObserveDecoratorProvider(localeEnum);
        ObserveContext.setObserveDecoratorProvider(provider);
        log.info((Object)I18n._((String)"observe.message.config.loaded", (Object[])new Object[]{config.getVersion()}));
        try {
            UIHelper.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"observe.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"observe.warning.no.ui"));
            config.setCanUseUI(false);
        }
        if (config.isCanUseUI()) {
            UIHelper.loadUIConfig((String)"/observe.properties", null);
        }
        if (initLocalSotrage) {
            boolean hasLocalStorage = context.isLocalStorageExists();
            config.setLocalStorageExist(hasLocalStorage);
            if (!hasLocalStorage) {
                log.info((Object)I18n._((String)"observe.init.no.local.db.detected", (Object[])new Object[]{config.getLocalDBDirectory()}));
            }
            boolean hasInitialDb = context.isInitialDbExists();
            config.setInitialDumpExist(hasInitialDb);
            if (!hasInitialDb) {
                log.info((Object)I18n._((String)"observe.init.no.initial.dump.detected", (Object[])new Object[]{config.getInitialDbDump()}));
            }
        }
        StorageServiceFactory.setApplicationContext((DefaultApplicationContext)context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    @Override
    public void run() {
        long startingTime = System.nanoTime();
        log.info((Object)("Observe start at " + new Date() + " args: " + Arrays.toString(this.args)));
        System.setSecurityManager(null);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        try {
            ObserveContext context = this.init(true, this.args);
            String time = StringUtil.convertTime((long)startingTime, (long)System.nanoTime());
            log.info((Object)I18n._((String)"observe.init.context.done", (Object[])new Object[]{time}));
            UIHelper.checkJAXXContextEntries((JAXXContext)context, (JAXXContextEntryDef[])new JAXXContextEntryDef[]{ObserveContext.CONFIG_ENTRY_DEF, ObserveContext.ACTIONS_ENTRY_DEF, ObserveContext.DATA_CONTEXT_ENTRY_DEF, ObserveContext.ACTION_THREAD_ENTRY_DEF, ObserveContext.DECORATOR_PROVIDER_ENTRY_DEF});
            ObserveConfig config = ObserveContext.getConfig();
            config.doAction(ObserveConfig.Step.AfterInit.ordinal());
            if (!config.isDisplayMainUI()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"observe.init.quit.withno.ui"));
                }
                return;
            }
            ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
            final ObserveMainUI ui = uiHandler.initUI(context, config);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ui.setVisible(true);
                }
            });
            log.info((Object)I18n._((String)"observe.init.ui.done"));
            ObserveContext.runAction("init main database", (Object)context, "initStorage", new Object[]{config, ui, true});
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    static {
        lock = new Object();
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown ObServe");
        }

        @Override
        public void run() {
            try {
                super.run();
                ObserveContext.get().close();
                log.info((Object)I18n._((String)"observe.init.closed", (Object[])new Object[]{new Date()}));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

