/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveAction;
import fr.ird.observe.ObserveActionThread;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceAdapter;
import fr.ird.observe.storage.StorageServiceEvent;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.StorageServiceListener;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.io.IOException;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.jdbc.JdbcSQLException;
import org.nuiton.i18n.I18n;

public class ObserveContext
extends DefaultApplicationContext {
    private static Log log = LogFactory.getLog(ObserveContext.class);
    private static final JAXXContextEntryDef<ObserveMainUI> MAIN_UI_ENTRY_DEF = UIHelper.newContextEntryDef((String)"mainui", ObserveMainUI.class);
    public static final JAXXContextEntryDef<ObserveContent> SELECTED_CONTENT_UI_ENTRY_DEF = UIHelper.newContextEntryDef((String)"selected-content-ui", ObserveContent.class);
    public static final JAXXContextEntryDef<ObserveActionThread> ACTION_THREAD_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveActionThread.class);
    public static final JAXXContextEntryDef<ObserveConfig> CONFIG_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveConfig.class);
    public static final JAXXContextEntryDef<ObserveDataContext> DATA_CONTEXT_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveDataContext.class);
    public static final JAXXContextEntryDef<ObserveAction> ACTIONS_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveAction.class);
    public static final JAXXContextEntryDef<ObserveDecoratorProvider> DECORATOR_PROVIDER_ENTRY_DEF = UIHelper.newContextEntryDef(ObserveDecoratorProvider.class);
    protected static ObserveContext instance;
    protected final Object lock = new Object();

    public static boolean isInit() {
        return instance != null;
    }

    public static synchronized ObserveContext init() throws IllegalStateException {
        if (ObserveContext.isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new ObserveContext();
        CONFIG_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)new ObserveConfig());
        DATA_CONTEXT_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)new ObserveDataContext());
        ACTIONS_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)new ObserveAction());
        ObserveActionThread actionThread = new ObserveActionThread();
        ACTION_THREAD_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)actionThread);
        actionThread.start();
        return instance;
    }

    public static ObserveContext get() throws IllegalStateException {
        if (!ObserveContext.isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    public static <O> Decorator<O> getDecorator(Class<O> clazz) {
        ObserveDecoratorProvider provider = ObserveContext.getObserveDecoratorProvider();
        Decorator value = provider.getDecorator(clazz);
        return value;
    }

    public static <O> Decorator<O> getDecorator(Class<O> clazz, String name) {
        ObserveDecoratorProvider provider = ObserveContext.getObserveDecoratorProvider();
        Decorator value = provider.getDecorator(clazz, name);
        return value;
    }

    public static ObserveActionThread getActionThread() {
        return (ObserveActionThread)((Object)ACTION_THREAD_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get()));
    }

    public static ObserveConfig getConfig() {
        return (ObserveConfig)((Object)CONFIG_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get()));
    }

    public static ObserveDataContext getDataContext() {
        return (ObserveDataContext)DATA_CONTEXT_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get());
    }

    public static ObserveMainUI getObserveMainUI() {
        return (ObserveMainUI)MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get());
    }

    public static ObserveDecoratorProvider getObserveDecoratorProvider() {
        return (ObserveDecoratorProvider)DECORATOR_PROVIDER_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get());
    }

    public static void setObserveMainUI(ObserveMainUI ui) {
        MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)ObserveContext.get(), (Object)ui);
    }

    public static void setObserveDecoratorProvider(ObserveDecoratorProvider provider) {
        DECORATOR_PROVIDER_ENTRY_DEF.setContextValue((JAXXContext)ObserveContext.get(), (Object)provider);
    }

    public static void removeObserveMainUI() {
        MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
    }

    protected ObserveContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing context " + (Object)((Object)this)));
        }
        ObserveContext.getDataContext().close();
        StorageServiceFactory.dispose();
        ObserveContext.getActionThread().cancel();
        this.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("context closed" + (Object)((Object)this)));
        }
        instance = null;
    }

    public H2StorageService newLocalStorageService() throws StorageServiceException, IOException, IllegalStateException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        H2StorageConfig c = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        c.init();
        if (!c.isStorageExists()) {
            throw new IllegalStateException("local base must exist, when using this method (" + c.getStorageDirectory() + ')');
        }
        H2StorageService service = StorageServiceFactory.newService((H2StorageConfig)c);
        return service;
    }

    public boolean isLocalStorageExists() throws IOException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        H2StorageConfig storageConfig = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        storageConfig.init();
        boolean dbExists = storageConfig.isStorageExists();
        return dbExists;
    }

    public boolean isInitialDbExists() throws IOException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        boolean dbExists = config.getInitialDbDump().exists();
        return dbExists;
    }

    public void initStorage(ObserveConfig config, ObserveMainUI mainUI, boolean askToCreate) {
        try {
            if (config.isLocalStorageExist()) {
                this.loadLocalStorage();
                mainUI.setMode(ObserveUIMode.DB);
            } else {
                mainUI.setMode(ObserveUIMode.NO_DB);
                if (askToCreate) {
                    this.createStorage(config, mainUI.getHandler());
                }
            }
            log.info((Object)I18n._((String)"observe.init.storage.done"));
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createStorage(ObserveConfig config, ObserveMainUIHandler uiHandler) {
        int reponse = UIHelper.askUser(I18n._((String)"observe.title.no.local.db.found"), I18n._((String)"observe.message.no.local.db.found", (Object[])new Object[]{config.getLocalDBDirectory()}), 3, new Object[]{I18n._((String)"observe.choice.useRemoteStorage"), I18n._((String)"observe.choice.createLocalStorage"), I18n._((String)"observe.choice.doNothing")}, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("response : " + reponse));
        }
        DbMode dbMode = null;
        String title = null;
        if (reponse != -1 && reponse < 2) {
            if (reponse == 1) {
                dbMode = DbMode.CREATE_LOCAL;
                title = I18n.n_((String)"observe.title.create.local.db");
            } else {
                dbMode = DbMode.USE_REMOTE;
                title = I18n.n_((String)"observe.title.load.remote.db");
            }
        }
        if (dbMode != null) {
            uiHandler.launchChangeStorage((JAXXContext)this, dbMode, title);
        }
    }

    protected void loadLocalStorage() throws Exception {
        H2StorageService service = this.newLocalStorageService();
        this.prepareMainStorage((StorageService<?>)service);
        log.info((Object)I18n._((String)"observe.init.local.db.detected", (Object[])new Object[]{service.getLabel()}));
        try {
            service.doOpen();
        }
        catch (Exception eee) {
            JdbcSQLException error;
            Throwable cause;
            for (cause = eee.getCause(); cause != null && cause.getCause() != null; cause = cause.getCause()) {
            }
            if (cause != null && cause instanceof JdbcSQLException && (error = (JdbcSQLException)cause).getMessage().contains("Locked")) {
                JOptionPane.showMessageDialog(null, I18n._((String)"observe.error.open.first.db"), I18n._((String)"observe.title.error.dialog"), 0);
                return;
            }
            throw eee;
        }
    }

    public void prepareMainStorage(StorageService<?> service) {
        service.getConfig().setUseCache(true);
        service.addStorageServiceListener((StorageServiceListener)new StorageServiceAdapter(){

            public void onOpening(StorageServiceEvent event) {
                StorageService s = event.getSource();
                UIHelper.displayInfo(I18n._((String)"observe.message.db.loading", (Object[])new Object[]{s.getLabel()}));
            }

            public void onOpened(StorageServiceEvent event) {
                ObserveMainUI mainUI;
                StorageService s = event.getSource();
                ObserveDataContext dataContext = ObserveContext.getDataContext();
                dataContext.installStorage(s);
                ObserveConfig config = (ObserveConfig)((Object)ObserveContext.this.getContextValue(ObserveConfig.class));
                config.setMainStorageOpened(true);
                config.setMainStorageOpenedLocal(s instanceof H2StorageService);
                if (s instanceof H2StorageService) {
                    config.setLocalStorageExist(true);
                }
                if ((mainUI = ObserveContext.getObserveMainUI()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("loading ui for storage " + s.getLabel() + ": " + mainUI.getName()));
                    }
                    ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
                    treeHelper.cleanNavigationUI(mainUI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("tree helper to use : " + (Object)((Object)treeHelper)));
                    }
                    treeHelper.loadNavigationUI(mainUI);
                    if (ObserveUIMode.NO_DB.equals((Object)mainUI.getMode())) {
                        mainUI.setMode(ObserveUIMode.DB);
                    }
                    mainUI.getStatus().setStatus(I18n._((String)"observe.message.db.loaded", (Object[])new Object[]{s.getLabel()}));
                }
            }

            public void onClosed(StorageServiceEvent event) {
                StorageService service = event.getSource();
                ObserveContext.getConfig().setMainStorageOpened(false);
                ObserveDataContext dataContext = ObserveContext.getDataContext();
                dataContext.uninstallStorage(service);
                ObserveMainUI mainUI = ObserveContext.getObserveMainUI();
                if (mainUI != null) {
                    ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dispose ui from storage " + service.getLabel() + ": " + mainUI.getName()));
                    }
                    if (ObserveUIMode.DB.equals((Object)mainUI.getMode())) {
                        mainUI.setMode(ObserveUIMode.NO_DB);
                    }
                    treeHelper.cleanNavigationUI(mainUI);
                    UIHelper.displayInfo(I18n._((String)"observe.message.db.closed", (Object[])new Object[]{service.getLabel()}));
                }
            }
        });
    }

    public static void runAction(String actionLabel, Object invoker, String methodName, Object ... arguments) {
        Runnable action;
        try {
            action = ObserveContext.getActionThread().createRunnable(invoker, methodName, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("could not create action " + actionLabel, e);
        }
        ObserveContext.runAction(actionLabel, action);
    }

    public static void runAction(String actionLabel, Runnable action) {
        ObserveContext.getActionThread().addAction(actionLabel, action);
    }
}

