/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompConfigurationOption.java 258 2012-02-01 12:40:09Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompConfigurationOption.java $
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.nuiton.util.ApplicationConfig;

import java.io.File;
import java.util.Locale;

import static org.nuiton.i18n.I18n._;

public enum RefcompConfigurationOption implements ApplicationConfig.OptionDef {

    ADMIN_EMAIL(
            "refcomp.admin.email",
            _("refcomp.config.admin.email.description"),
    "couteau@codelutin.com", String.class, false, false),

    ADMIN_LOGIN(
            "refcomp.admin.login",
            _("refcomp.config.admin.login.description"),
    "admin", String.class, false, false),

    ADMIN_PASSWORD(
            "refcomp.admin.password",
            _("refcomp.config.admin.password.description"),
    "admin", String.class, false, false),

    CONFIG_FILE(
            "refcomp.config.file.name",
            _("refcomp.config.configFileName.description"),
    "refcomp.properties",
    String.class, true, true),

    APPLICATION_VERSION(
            "application.version",
            _("refcomp.config.application.version.description"),
    null, String.class, false, false),

    DATA_DIR(
            "refcomp.data.dir",
            _("refcomp.config.data.dir.description"),
    RefcompConfiguration.DATA_DEFAULT_DIR,
    String.class, false, false),

    LOCALE(
            "refcomp.locale",
            _("refcomp.config.ui.locale.description"),
    Locale.FRANCE.toString(), Locale.class, false, false),

    LDAP_SEARCH("refcomp.ldapSearch",
                _("refcomp.config.ui.ldapSearch.description"),
    "ou=personnes,dc=inra,dc=fr", String.class, false, false);


    public String key;
    public String description;
    public String defaultValue;
    public Class<?> type;
    public boolean isTransient;
    public boolean isFinal;



    private RefcompConfigurationOption(String key, String description, String defaultValue,
                          Class<?> type, boolean isTransient, boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isFinal = isFinal;
        this.isTransient = isTransient;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    private static String getDefaultDir(String dirName) {
        return RefcompConfiguration.DATA_DEFAULT_DIR + File.separator + dirName;
    }
}



