/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.conditions;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ContainerOperator;

public abstract class ContainerUnaryOperator
extends ContainerOperator {
    private static final long serialVersionUID = 1L;
    protected Condition subCondition;

    public ContainerUnaryOperator() {
    }

    public ContainerUnaryOperator(Condition restriction) {
        this.subCondition = restriction;
    }

    @Override
    public boolean waitCondition() {
        boolean result = this.subCondition == null;
        return result;
    }

    @Override
    public Condition addCondition(Condition c) {
        if (c instanceof ConditionValue) {
            throw new WikittyException(String.format("Condition (%s) can't have condition '%s' as child", this.getClass().getSimpleName(), ClassUtils.getShortCanonicalName((Object)c, (String)"null")));
        }
        if (this.subCondition != null) {
            throw new WikittyException(String.format("Condition (%s) can't have more than one condition", this.getClass().getSimpleName()));
        }
        this.subCondition = c;
        return this;
    }

    @Override
    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk && this.subCondition != null) {
            this.subCondition.accept(visitor);
        }
        visitor.visitLeave(this, walk);
    }

    @Override
    boolean equalsDeep(Object other) {
        ContainerUnaryOperator op = (ContainerUnaryOperator)other;
        boolean result = ObjectUtils.equals((Object)this.getSubCondition(), (Object)op.getSubCondition());
        return result;
    }

    public Condition getSubCondition() {
        return this.subCondition;
    }
}

