/*
 * Decompiled with CFR 0.152.
 */
package org.apache.noggit;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.noggit.CharArr;

class CharArrReader
extends CharArr {
    protected final Reader in;

    public CharArrReader(Reader in, int size) {
        super(size);
        this.in = in;
    }

    public int read() throws IOException {
        if (this.start >= this.end) {
            this.fill();
        }
        return this.start >= this.end ? -1 : this.buf[this.start++];
    }

    public int read(CharBuffer cb) throws IOException {
        int sz2;
        int sz = this.size();
        if (sz > 0) {
            cb.put(this.buf, this.start, this.end);
        }
        if ((sz2 = this.in.read(cb)) >= 0) {
            return sz + sz2;
        }
        return sz > 0 ? sz : -1;
    }

    public int fill() throws IOException {
        if (this.start >= this.end) {
            this.reset();
        } else if (this.start > 0) {
            System.arraycopy(this.buf, this.start, this.buf, 0, this.size());
            this.end = this.size();
            this.start = 0;
        }
        int sz = this.in.read(this.buf, this.end, this.buf.length - this.end);
        if (sz > 0) {
            this.end += sz;
        }
        return sz;
    }
}

