/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionEventListener;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.UnknownHandlerManager;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultActionProxy
implements ActionProxy,
Serializable {
    private static final long serialVersionUID = 3293074152487468527L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultActionProxy.class);
    protected Configuration configuration;
    protected ActionConfig config;
    protected ActionInvocation invocation;
    protected UnknownHandlerManager unknownHandlerManager;
    protected String actionName;
    protected String namespace;
    protected String method;
    protected boolean executeResult;
    protected boolean cleanupContext;
    protected ObjectFactory objectFactory;
    protected ActionEventListener actionEventListener;

    protected DefaultActionProxy(ActionInvocation inv, String namespace, String actionName, String methodName, boolean executeResult, boolean cleanupContext) {
        this.invocation = inv;
        this.cleanupContext = cleanupContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating an DefaultActionProxy for namespace " + namespace + " and action name " + actionName, new String[0]);
        }
        this.actionName = StringEscapeUtils.escapeHtml((String)actionName);
        this.namespace = namespace;
        this.executeResult = executeResult;
        this.method = StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)methodName));
    }

    @Inject
    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    @Inject
    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    @Inject
    public void setUnknownHandler(UnknownHandlerManager unknownHandlerManager) {
        this.unknownHandlerManager = unknownHandlerManager;
    }

    @Inject(required=false)
    public void setActionEventListener(ActionEventListener listener) {
        this.actionEventListener = listener;
    }

    public Object getAction() {
        return this.invocation.getAction();
    }

    public String getActionName() {
        return this.actionName;
    }

    public ActionConfig getConfig() {
        return this.config;
    }

    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    public boolean getExecuteResult() {
        return this.executeResult;
    }

    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ActionContext nestedContext = ActionContext.getContext();
        ActionContext.setContext(this.invocation.getInvocationContext());
        String retCode = null;
        String profileKey = "execute: ";
        try {
            UtilTimerStack.push(profileKey);
            retCode = this.invocation.invoke();
        }
        finally {
            if (this.cleanupContext) {
                ActionContext.setContext(nestedContext);
            }
            UtilTimerStack.pop(profileKey);
        }
        return retCode;
    }

    public String getMethod() {
        return this.method;
    }

    private void resolveMethod() {
        if (StringUtils.isEmpty((String)this.method)) {
            this.method = this.config.getMethodName();
            if (StringUtils.isEmpty((String)this.method)) {
                this.method = "execute";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepare() {
        String profileKey = "create DefaultActionProxy: ";
        try {
            UtilTimerStack.push(profileKey);
            this.config = this.configuration.getRuntimeConfiguration().getActionConfig(this.namespace, this.actionName);
            if (this.config == null && this.unknownHandlerManager.hasUnknownHandlers()) {
                this.config = this.unknownHandlerManager.handleUnknownAction(this.namespace, this.actionName);
            }
            if (this.config == null) {
                String message = this.namespace != null && this.namespace.trim().length() > 0 ? LocalizedTextUtil.findDefaultText("xwork.exception.missing-package-action", Locale.getDefault(), new String[]{this.namespace, this.actionName}) : LocalizedTextUtil.findDefaultText("xwork.exception.missing-action", Locale.getDefault(), new String[]{this.actionName});
                throw new ConfigurationException(message);
            }
            this.resolveMethod();
            if (!this.config.isAllowedMethod(this.method)) {
                throw new ConfigurationException("Invalid method: " + this.method + " for action " + this.actionName);
            }
            this.invocation.init(this);
        }
        finally {
            UtilTimerStack.pop(profileKey);
        }
    }
}

