/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class ObjectUtil {
    private static Log log = LogFactory.getLog(ObjectUtil.class);
    protected static final Integer ZERO = 0;
    protected static final Character ZEROC = Character.valueOf('\u0000');
    protected static final Float ZEROF = Float.valueOf(0.0f);
    protected static final Long ZEROL = 0L;
    protected static final Double ZEROD = 0.0;
    protected static final Byte ZEROB = 0;

    private ObjectUtil() {
    }

    public static <E> E newInstance(Class<E> clazz, Collection args, boolean nullIfMissing) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length != 1) {
            throw new IllegalArgumentException(I18n._((String)"nuitonutil.erro.class.with.more.than.one.constructor", (Object[])new Object[]{clazz}));
        }
        LinkedList container = new LinkedList(args);
        Constructor<?> constructor = constructors[0];
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object o;
            params[i] = o = ObjectUtil.choiceArgument(paramTypes[i], container, nullIfMissing);
        }
        try {
            Object result = constructor.newInstance(params);
            return (E)result;
        }
        catch (Exception eee) {
            throw new IllegalArgumentException(I18n._((String)I18n._((String)"nuitonutil.error.cant.instanciate.class", (Object[])new Object[]{clazz, Arrays.toString(params)}), (Object[])new Object[0]), eee);
        }
    }

    protected static Object choiceArgument(Class clazz, List args, boolean nullIfMissing) {
        Object result = null;
        boolean addResult = false;
        for (Object o : args) {
            if (o == null) continue;
            if (o instanceof Class && clazz.isAssignableFrom((Class)o)) {
                result = ObjectUtil.newInstance((Class)o, args, nullIfMissing);
                addResult = true;
                break;
            }
            if (!clazz.isInstance(o)) continue;
            result = o;
            break;
        }
        if (addResult) {
            args.add(0, result);
        }
        if (result == null && !nullIfMissing) {
            throw new IllegalArgumentException(I18n._((String)I18n._((String)"nuitonutil.error.unfound.assignable.argument", (Object[])new Object[]{clazz, args}), (Object[])new Object[0]));
        }
        return result;
    }

    public static Object create(String classnameAndProperties) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int p = classnameAndProperties.indexOf(40);
        int l = classnameAndProperties.lastIndexOf(41);
        String[] properties = null;
        String classname = null;
        if (p != -1) {
            String tmp = classnameAndProperties.substring(p + 1, l);
            properties = StringUtil.split(tmp, ",");
            classname = classnameAndProperties.substring(0, p);
        } else {
            classname = classnameAndProperties;
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        Object o = clazz.newInstance();
        if (properties != null) {
            for (String prop : properties) {
                int e = prop.indexOf(61);
                String propName = prop.substring(0, e).trim();
                String propValue = prop.substring(e + 1).trim();
                if (propValue.charAt(0) == '\"' && propValue.charAt(propValue.length() - 1) == '\"') {
                    propValue = propValue.substring(1, propValue.length() - 1);
                } else if (propValue.charAt(0) == '\'' && propValue.charAt(propValue.length() - 1) == '\'') {
                    propValue = propValue.substring(1, propValue.length() - 1);
                }
                BeanUtils.setProperty(o, (String)propName, (Object)propValue);
            }
        }
        return o;
    }

    protected static Object convert(String v, Class<?> clazz) {
        Object t = ConvertUtils.convert((String)v, clazz);
        if (t != null && !String.class.getName().equals(clazz.getName()) && String.class.getName().equals(t.getClass().getName())) {
            throw new IllegalArgumentException(String.format("Can convert argument to correct type. %s can't be converted from String to %s conversion is done to %s", v, clazz.getName(), t.getClass().getName()));
        }
        return t;
    }

    public static <E extends Cloneable> E clone(E e) throws CloneNotSupportedException {
        try {
            Cloneable result = (Cloneable)MethodUtils.invokeExactMethod(e, (String)"clone", null);
            return (E)result;
        }
        catch (Exception eee) {
            log.error((Object)"Can't clone object", (Throwable)eee);
            throw new CloneNotSupportedException();
        }
    }

    public static <E> E deepClone(E e) throws CloneNotSupportedException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(e);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object result = ois.readObject();
            ois.close();
            return (E)result;
        }
        catch (Exception eee) {
            log.error((Object)"Can't clone object", (Throwable)eee);
            throw new CloneNotSupportedException();
        }
    }

    public static Object call(Object o, Method m, String ... params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Class<?>[] types = m.getParameterTypes();
        if (!m.isVarArgs() && params.length != types.length) {
            throw new IllegalArgumentException(String.format("Bad number params we have %1$s parameters and waiting %2$s.", params.length, types.length));
        }
        int last = types.length;
        if (m.isVarArgs()) {
            --last;
        }
        Object[] parameters = new Object[types.length];
        for (int i = 0; i < last; ++i) {
            Object t;
            String v = params[i];
            Class<?> clazz = types[i];
            parameters[i] = t = ObjectUtil.convert(v, clazz);
        }
        if (m.isVarArgs()) {
            Class<?> clazz = types[last];
            clazz = clazz.getComponentType();
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (int i = last; i < params.length; ++i) {
                String v = params[i];
                Object t = ObjectUtil.convert(v, clazz);
                tmp.add(t);
            }
            parameters[last] = tmp.toArray((Object[])Array.newInstance(clazz, tmp.size()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"nuitonutil.debug.objectutil.invoke", (Object[])new Object[]{m, Arrays.toString(parameters)}));
        }
        Object result = m.invoke(o, parameters);
        return result;
    }

    public static List<Method> getMethod(Class<?> clazz, String methodName, boolean ignoreCase) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            if ((!ignoreCase || !methodName.equalsIgnoreCase(m.getName())) && !methodName.equals(m.getName())) continue;
            result.add(m);
        }
        return result;
    }

    public static Object newInstance(String constructorWithParams) throws ClassNotFoundException {
        int p = constructorWithParams.indexOf(40);
        int l = constructorWithParams.lastIndexOf(41);
        String[] params = null;
        String classname = null;
        if (p != -1) {
            String tmp = constructorWithParams.substring(p + 1, l);
            params = StringUtil.split(tmp, ",");
            classname = constructorWithParams.substring(0, p);
        } else {
            classname = constructorWithParams;
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        Object result = ObjectUtil.newInstance(clazz, params);
        return result;
    }

    public static <T> T newInstance(Class<T> clazz, String ... params) throws IllegalArgumentException {
        if (params == null) {
            params = new String[]{};
        }
        List<Constructor<T>> constructors = ObjectUtil.getConstructor(clazz, params.length);
        for (Constructor<T> c : constructors) {
            try {
                Class<?>[] types = c.getParameterTypes();
                int last = types.length;
                if (c.isVarArgs()) {
                    --last;
                }
                Object[] parameters = new Object[types.length];
                for (int i = 0; i < last; ++i) {
                    Object t;
                    String v = params[i];
                    Class<?> argClazz = types[i];
                    parameters[i] = t = ObjectUtil.convert(v, argClazz);
                }
                if (c.isVarArgs()) {
                    Class<?> argClazz = types[last];
                    argClazz = argClazz.getComponentType();
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    for (int i = last; i < params.length; ++i) {
                        String v = params[i];
                        Object t = ObjectUtil.convert(v, argClazz);
                        tmp.add(t);
                    }
                    parameters[last] = tmp.toArray((Object[])Array.newInstance(argClazz, tmp.size()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n._((String)"nuitonutil.debug.objectutil.create", (Object[])new Object[]{clazz, Arrays.toString(parameters)}));
                }
                T result = c.newInstance(parameters);
                return result;
            }
            catch (Exception eee) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Creation failed try with next constructor");
            }
        }
        throw new IllegalArgumentException(I18n._((String)"nuitonutil.debug.objectutil.instantiate", (Object[])new Object[]{clazz, Arrays.toString(params)}));
    }

    public static <T> List<Constructor<T>> getConstructor(Class<T> clazz, int paramNumber) {
        Constructor<?>[] constructors;
        ArrayList<Constructor<T>> result = new ArrayList<Constructor<T>>();
        for (Constructor<?> c : constructors = clazz.getConstructors()) {
            if (paramNumber >= 0 && (!c.isVarArgs() || c.getParameterTypes().length > paramNumber - 1) && c.getParameterTypes().length != paramNumber) continue;
            result.add(c);
        }
        return result;
    }

    public static Object toObject(Object o) {
        return o;
    }

    public static Object toObject(char c) {
        return new Character(c);
    }

    public static Object toObject(byte b) {
        return new Byte(b);
    }

    public static Object toObject(short s) {
        return new Short(s);
    }

    public static Object toObject(int i) {
        return new Integer(i);
    }

    public static Object toObject(long l) {
        return new Long(l);
    }

    public static Object toObject(float f) {
        return new Float(f);
    }

    public static Object toObject(double d) {
        return new Double(d);
    }

    public static Object toObject(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object getNullValue(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("parameter 'type' can not be null");
        }
        if (type.isPrimitive()) {
            if (Boolean.class.isAssignableFrom(type = MethodUtils.getPrimitiveWrapper(type))) {
                return Boolean.FALSE;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return ZERO;
            }
            if (Character.class.isAssignableFrom(type)) {
                return ZEROC;
            }
            if (Float.class.isAssignableFrom(type)) {
                return ZEROF;
            }
            if (Long.class.isAssignableFrom(type)) {
                return ZEROL;
            }
            if (Double.class.isAssignableFrom(type)) {
                return ZEROD;
            }
            if (Byte.class.isAssignableFrom(type)) {
                return ZEROB;
            }
        }
        return null;
    }

    public static boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        Class type = value.getClass();
        if (type.isPrimitive()) {
            if (Boolean.class.isAssignableFrom(type = MethodUtils.getPrimitiveWrapper(type))) {
                return Boolean.FALSE.equals(value);
            }
            if (Integer.class.isAssignableFrom(type)) {
                return ZERO.equals(value);
            }
            if (Character.class.isAssignableFrom(type)) {
                return ZEROC.equals(value);
            }
            if (Float.class.isAssignableFrom(type)) {
                return ZEROF.equals(value);
            }
            if (Long.class.isAssignableFrom(type)) {
                return ZEROL.equals(value);
            }
            if (Double.class.isAssignableFrom(type)) {
                return ZEROD.equals(value);
            }
            if (Byte.class.isAssignableFrom(type)) {
                return ZEROB.equals(value);
            }
        }
        return false;
    }

    public static boolean isNullValue(boolean value) {
        return Boolean.FALSE.equals(value);
    }

    public static boolean isNullValue(byte value) {
        return value == ZEROB;
    }

    public static boolean isNullValue(int value) {
        return value == ZEROB;
    }

    public static boolean isNullValue(char value) {
        return value == ZEROC.charValue();
    }

    public static boolean isNullValue(float value) {
        return value == ZEROF.floatValue();
    }

    public static boolean isNullValue(double value) {
        return value == ZEROD;
    }
}

