/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.tst;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.spelling.suggest.Lookup;
import org.apache.solr.spelling.suggest.SortedTermFreqIteratorWrapper;
import org.apache.solr.spelling.suggest.tst.TSTAutocomplete;
import org.apache.solr.spelling.suggest.tst.TernaryTreeNode;
import org.apache.solr.util.SortedIterator;
import org.apache.solr.util.TermFreqIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSTLookup
extends Lookup {
    TernaryTreeNode root = new TernaryTreeNode();
    TSTAutocomplete autocomplete = new TSTAutocomplete();
    public static final String FILENAME = "tst.dat";
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_TOKEN = 8;
    private static final byte HAS_VALUE = 16;

    @Override
    public void init(NamedList config, SolrCore core) {
    }

    @Override
    public void build(TermFreqIterator tfit) throws IOException {
        this.root = new TernaryTreeNode();
        if (!(tfit instanceof SortedIterator)) {
            tfit = new SortedTermFreqIteratorWrapper(tfit);
        }
        ArrayList tokens = new ArrayList();
        ArrayList<Float> vals = new ArrayList<Float>();
        while (tfit.hasNext()) {
            tokens.add(tfit.next());
            vals.add(new Float(tfit.freq()));
        }
        this.autocomplete.balancedTree(tokens.toArray(), vals.toArray(), 0, tokens.size() - 1, this.root);
    }

    @Override
    public boolean add(String key, Object value) {
        this.autocomplete.insert(this.root, key, value, 0);
        return true;
    }

    @Override
    public Object get(String key) {
        ArrayList<TernaryTreeNode> list = this.autocomplete.prefixCompletion(this.root, key, 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (TernaryTreeNode n : list) {
            if (!n.token.equals(key)) continue;
            return n.val;
        }
        return null;
    }

    @Override
    public List<Lookup.LookupResult> lookup(String key, boolean onlyMorePopular, int num) {
        ArrayList<TernaryTreeNode> list = this.autocomplete.prefixCompletion(this.root, key, 0);
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        if (list == null || list.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (TernaryTreeNode ttn : list) {
                queue.insertWithOverflow(new Lookup.LookupResult(ttn.token, ((Float)ttn.val).floatValue()));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                TernaryTreeNode ttn = (TernaryTreeNode)list.get(i);
                res.add(new Lookup.LookupResult(ttn.token, ((Float)ttn.val).floatValue()));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File storeDir) throws IOException {
        File data = new File(storeDir, FILENAME);
        if (!data.exists() || !data.canRead()) {
            return false;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(data));
        this.root = new TernaryTreeNode();
        try {
            this.readRecursively(in, this.root);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return true;
    }

    private void readRecursively(DataInputStream in, TernaryTreeNode node) throws IOException {
        node.splitchar = in.readChar();
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.token = in.readUTF();
        }
        if ((mask & 0x10) != 0) {
            node.val = new Float(in.readFloat());
        }
        if ((mask & 1) != 0) {
            node.loKid = new TernaryTreeNode();
            this.readRecursively(in, node.loKid);
        }
        if ((mask & 2) != 0) {
            node.eqKid = new TernaryTreeNode();
            this.readRecursively(in, node.eqKid);
        }
        if ((mask & 4) != 0) {
            node.hiKid = new TernaryTreeNode();
            this.readRecursively(in, node.hiKid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(File storeDir) throws IOException {
        if (!(storeDir.exists() && storeDir.isDirectory() && storeDir.canWrite())) {
            return false;
        }
        File data = new File(storeDir, FILENAME);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(data));
        try {
            this.writeRecursively(out, this.root);
            out.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
        return true;
    }

    private void writeRecursively(DataOutputStream out, TernaryTreeNode node) throws IOException {
        out.writeChar(node.splitchar);
        int mask = 0;
        if (node.eqKid != null) {
            mask = (byte)(mask | 2);
        }
        if (node.loKid != null) {
            mask = (byte)(mask | 1);
        }
        if (node.hiKid != null) {
            mask = (byte)(mask | 4);
        }
        if (node.token != null) {
            mask = (byte)(mask | 8);
        }
        if (node.val != null) {
            mask = (byte)(mask | 0x10);
        }
        out.writeByte(mask);
        if (node.token != null) {
            out.writeUTF(node.token);
        }
        if (node.val != null) {
            out.writeFloat(((Float)node.val).floatValue());
        }
        if (node.loKid != null) {
            this.writeRecursively(out, node.loKid);
        }
        if (node.eqKid != null) {
            this.writeRecursively(out, node.eqKid);
        }
        if (node.hiKid != null) {
            this.writeRecursively(out, node.hiKid);
        }
    }
}

