/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.ArrayUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static final Pattern SETTER_PATTERN = Pattern.compile("set([A-Z][A-Za-z0-9]*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is|has)([A-Z][A-Za-z0-9]*)$");

    public static void addAllFields(Class annotationClass, Class clazz, List<Field> allFields) {
        Field[] fields;
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object ann = field.getAnnotation(annotationClass);
            if (ann == null) continue;
            allFields.add(field);
        }
        AnnotationUtils.addAllFields(annotationClass, clazz.getSuperclass(), allFields);
    }

    public static void addAllMethods(Class annotationClass, Class clazz, List<Method> allMethods) {
        Method[] methods;
        if (clazz == null) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Object ann = method.getAnnotation(annotationClass);
            if (ann == null) continue;
            allMethods.add(method);
        }
        AnnotationUtils.addAllMethods(annotationClass, clazz.getSuperclass(), allMethods);
    }

    public static void addAllInterfaces(Class clazz, List<Class> allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        AnnotationUtils.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    public static final Collection<Method> getAnnotatedMethods(Class clazz, Class<? extends Annotation> ... annotation) {
        HashSet<Method> toReturn = new HashSet<Method>();
        for (Method m : clazz.getMethods()) {
            if (ArrayUtils.isNotEmpty(annotation) && AnnotationUtils.isAnnotatedBy(m, annotation)) {
                toReturn.add(m);
                continue;
            }
            if (!ArrayUtils.isEmpty(annotation) || !ArrayUtils.isNotEmpty(m.getAnnotations())) continue;
            toReturn.add(m);
        }
        return toReturn;
    }

    public static final boolean isAnnotatedBy(AnnotatedElement annotatedElement, Class<? extends Annotation> ... annotation) {
        if (ArrayUtils.isEmpty(annotation)) {
            return false;
        }
        for (Class<? extends Annotation> c : annotation) {
            if (!annotatedElement.isAnnotationPresent(c)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static List<Method> findAnnotatedMethods(Class clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        AnnotationUtils.findRecursively(clazz, annotationClass, methods);
        return methods;
    }

    @Deprecated
    public static void findRecursively(Class clazz, Class<? extends Annotation> annotationClass, List<Method> methods) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(annotationClass) == null) continue;
            methods.add(0, m);
        }
        if (clazz.getSuperclass() != Object.class) {
            AnnotationUtils.findRecursively(clazz.getSuperclass(), annotationClass, methods);
        }
    }

    public static String resolvePropertyName(Method method) {
        Matcher matcher = SETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 1) {
            String raw = matcher.group(1);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        matcher = GETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 0) {
            String raw = matcher.group(2);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        return null;
    }

    public static String[] find(Class clazz, String pckgname) {
        URL url;
        File directory;
        ArrayList<String> classes = new ArrayList<String>();
        String name = new String(pckgname);
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = clazz.getResource(name = name.replace('.', File.separatorChar))).getFile())).exists()) {
            String[] files;
            for (String file : files = directory.list()) {
                if (!file.endsWith(".class")) continue;
                classes.add(pckgname + "." + file.substring(0, file.length() - 6));
            }
        }
        return classes.toArray(new String[classes.size()]);
    }
}

