/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: SkillsCreation.java 270 2012-03-19 15:30:20Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/agent/SkillsCreation.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.agent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.*;
import fr.inra.refcomp.client.admin.skills.GreenTree;
import fr.inra.refcomp.client.admin.skills.TreeItemCallback;
import fr.inra.refcomp.client.admin.skills.TreeRootCallback;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Skill;
import org.nuiton.web.gwt.misc.BlindedPopup;

import java.util.ArrayList;
import java.util.List;

/**
 * User: couteau
 * Date: 30/12/10
 */
public class SkillsCreation extends Composite {
    @UiTemplate("SkillsCreation.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, SkillsCreation> {
    }

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    protected SkillsTableScreen table;

    @UiField
    ScrollPanel skillsPanel;
    
    @UiField
    ListBox skillsList;

    @UiField
    ListBox frequencyBox;

    static Tree skillsTree;

    @UiHandler("addButton")
    public void add(ClickEvent event){
        TreeItem item = skillsTree.getSelectedItem();
        Skill value = (Skill)item.getUserObject();
        
        skillsList.addItem(value.getName(), value.getWikittyId());
    }

    @UiHandler("removeButton")
    public void remove(ClickEvent event){
        int selectedIndex = skillsList.getSelectedIndex();
        skillsList.removeItem(selectedIndex);
    }

    @UiHandler("validateButton")
    public void validate(ClickEvent event){

        int itemNb = skillsList.getItemCount();
        
        List<String> skillIds = new ArrayList<String> ();

        for (int i=0; i< itemNb; i++) {
            skillIds.add(skillsList.getValue(i));
        }

        skillsList.clear();

        table.createSkills(skillIds, frequencyBox.getValue(frequencyBox.getSelectedIndex()));

        ((BlindedPopup)this.getParent()).hide();
    }

    @UiHandler("cancelButton")
    public void cancel(ClickEvent event){
        ((BlindedPopup)this.getParent()).hide();
    }

    public SkillsCreation(SkillsTableScreen table) {
        this.table = table;
        initWidget(binder.createAndBindUi(this));

        service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
            @Override
            public void onSuccess(List<Frequency> result) {
                for (Frequency freq : result) {
                    frequencyBox.addItem(freq.getName(), freq.getWikittyId());
                }
            }
        });

        GreenTree greenTree = new GreenTree();
        skillsTree = new Tree(greenTree, true);
        skillsPanel.add(skillsTree);

        skillsPanel.setSize("500px", "300px");

        //Tree loading at display
        TreeItem root = new TreeItem("Loading...");
        skillsTree.addItem(root);
        service.getChildrenSkill(null, new TreeRootCallback(skillsTree));
        skillsTree.addOpenHandler(new OpenHandler<TreeItem>() {
            public void onOpen(OpenEvent event) {
                if (needsLoading((TreeItem) event.getTarget())) {

                    Skill parentSkill = (Skill) ((TreeItem) event.getTarget()).getUserObject();

                    service.getChildrenSkill(parentSkill.getWikittyId(),
                            new TreeItemCallback((TreeItem) event.getTarget()));
                }
            }

        });

        DoubleClickHandler doubleClickHandler = new DoubleClickHandler() {
            @Override
            public void onDoubleClick(DoubleClickEvent doubleClickEvent) {

                TreeItem item = skillsTree.getSelectedItem();
                Skill value = (Skill)item.getUserObject();
                
                //is present ?
                boolean present = false;
                int index = 0;
                for (int i=0; i<skillsList.getItemCount();i++) {
                    if ( skillsList.getItemText(i).equals(value.getName())){
                        present = true;
                        index = i;
                    }
                }

                if (present) {
                    skillsList.removeItem(index);
                } else {
                    skillsList.addItem(value.getName(), value.getWikittyId());
                }
            }
        };

        skillsTree.addDomHandler(doubleClickHandler,
                DoubleClickEvent.getType());


    }

    protected static boolean needsLoading(TreeItem item) {
        return item.getChildCount() == 1
                && "Loading...".equals(item.getChild(0).getText());
    }
}
