/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: PrintSkills.java 264 2012-02-20 16:07:24Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/skills/PrintSkills.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.skills;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Tree;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 13/01/11
 */
public class PrintSkills extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("PrintSkills.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, PrintSkills> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    FlowPanel skillsPanel;

    static Tree skillsTree;

    public PrintSkills() {
        initWidget(binder.createAndBindUi(this));

        GreenTree greenTree = new GreenTree();
        skillsTree = new Tree(greenTree, true);

        service.getAllSkills(new FullTreeCallback(skillsTree));
        skillsPanel.add(skillsTree);
    }
}