/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: StorageServiceImpl.java 164 2011-05-13 13:12:11Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/server/StorageServiceImpl.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.AgentSkill;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Unit;
import fr.inra.refcomp.entities.User;
import fr.inra.refcomp.services.InvalidEntityException;
import fr.inra.refcomp.services.RefcompSession;
import fr.inra.refcomp.services.ServiceFactory;
import fr.inra.refcomp.services.UsedException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import fr.inra.refcomp.entities.Skill;
import fr.inra.refcomp.services.AlreadyExistingException;
import org.nuiton.wikitty.entities.WikittyUser;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
public class StorageServiceImpl extends RemoteServiceServlet implements
        StorageService {

    public List<User> getUsers() {
        return ServiceFactory.getService(getSession()).getUsers();
    }

    public User saveUser(User user, String context)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveUser(locale, context, user);
    }

    public User createUser() {
        return ServiceFactory.getService(getSession()).createUser();
    }

    public void deleteUser(User user) {
        ServiceFactory.getService(getSession()).deleteUser(user);
    }

    public User getUser(String id) {
        return ServiceFactory.getService(getSession()).getUser(id);
    }

    @Override
    public Agent getAgent(String id) {
        return ServiceFactory.getService(getSession()).getAgent(id);
    }

    @Override
    public EntitiesList getAgentAndDependencies(String id) {
        return ServiceFactory.getService(getSession()).getAgentAndDependencies(id);
    }

    @Override
    public Agent setAgent(User user) {
        return ServiceFactory.getService(getSession()).setAgent(user);
    }

    @Override
    public void unsetAgent(String id) {
        ServiceFactory.getService(getSession()).unsetAgent(id);
    }

    @Override
    public Agent saveAgent(Agent agent, String context)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveAgent(locale,
                context, agent);
    }

    public Boolean login(String login, String password) {
        RefcompSession session = getSession();
        fr.inra.refcomp.services.StorageService storageService = ServiceFactory.getService(session);
        Boolean loggedIn = storageService.login(login, password);
        if (loggedIn) {
            session.setUser(storageService.getLoggedInUser());
        }
        return loggedIn;
    }

    @Override
    public void logout() {
        RefcompSession session = getSession();
        session.clearUser();
        ServiceFactory.getService(session).logout();
    }

    public List<Frequency> getFrequencies() throws SecurityException {
        return ServiceFactory.getService(getSession()).getFrequencies();
    }

    public Frequency saveFrequency(Frequency frequency)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveFrequency(locale,
                frequency);
    }

    public Frequency createFrequency() {
        return ServiceFactory.getService(getSession()).createFrequency();
    }

    public void deleteFrequency(Frequency frequency, boolean force)
            throws UsedException {
        ServiceFactory.getService(getSession()).deleteFrequency(frequency, force);
    }

    public Frequency getFrequency(String id) {
        return ServiceFactory.getService(getSession()).getFrequency(id);
    }

    public List<Cati> getCatis() {
        return ServiceFactory.getService(getSession()).getCatis();
    }

    public Cati saveCati(Cati cati) throws AlreadyExistingException,
            InvalidEntityException {

        RefcompSession session = getSession();

        Locale locale = getLocale();

        return ServiceFactory.getService(session).saveCati(locale, cati);
    }

    public Cati createCati() {
        return ServiceFactory.getService(getSession()).createCati();
    }

    public void deleteCati(Cati cati) {
        ServiceFactory.getService(getSession()).deleteCati(cati);
    }

    public Cati getCati(String id) {
        return ServiceFactory.getService(getSession()).getCati(id);
    }

    public List<Skill> getChildrenSkill(String id) {
        return ServiceFactory.getService(getSession()).getChildrenSkill(id);
    }

    public Skill saveSkill(Skill skill)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveSkill(locale,
                skill);
    }

    public Skill createSkill(String parentId) {
        return ServiceFactory.getService(getSession()).createSkill(
                parentId);
    }

    public void deleteSkill(Skill skill) throws UsedException {
        ServiceFactory.getService(getSession()).deleteSkill(skill);
    }

    @Override
    public Unit saveUnit(Unit unit)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveUnit(locale, unit);
    }

    @Override
    public Unit saveUnit(Unit unit, List<String> departments)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveUnit(locale, unit,
                departments);
    }

    @Override
    public Unit createUnit() {
        return ServiceFactory.getService(getSession()).createUnit();
    }

    @Override
    public Unit getUnit(String id) {
        return ServiceFactory.getService(getSession()).getUnit(id);
    }

    @Override
    public void deleteUnit(Unit unit) {
        ServiceFactory.getService(getSession()).deleteUnit(unit);
    }

    @Override
    public List<Unit> getUnits() {
        return ServiceFactory.getService(getSession()).getUnits();
    }

    @Override
    public List<Unit> getUnits(String id) {
        return ServiceFactory.getService(getSession()).getUnits(id);
    }

    @Override
    public Department saveDepartment(Department department)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveDepartment(locale,
                department);
    }

    @Override
    public Department saveDepartment(Department department, List<String> units)
            throws AlreadyExistingException, InvalidEntityException {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveDepartment(locale,
                department, units);
    }

    @Override
    public Department createDepartment() {
        return ServiceFactory.getService(getSession()).createDepartment();
    }

    @Override
    public Department getDepartment(String id) {
        return ServiceFactory.getService(getSession()).getDepartment(id);
    }

    @Override
    public void deleteDepartment(Department department) {
        ServiceFactory.getService(getSession()).deleteDepartment(department);
    }

    @Override
    public List<Department> getDepartments() {
        return ServiceFactory.getService(getSession()).getDepartments();
    }

    @Override
    public List<Department> getDepartments(String id) {
        return ServiceFactory.getService(getSession()).getDepartments(id);
    }

    @Override
    public Skill getSkill(String id) {
        return ServiceFactory.getService(getSession()).getSkill(id);
    }

    @Override
    public String getAdminEmail(){
        return ServiceFactory.getService(getSession()).getAdminEmail();
    }

    @Override
    public Boolean isAdmin(){
        return ServiceFactory.getService(getSession()).isAdmin();
    }

    @Override
    public Boolean isAdmin(String id) {
        return ServiceFactory.getService(getSession()).isAdmin(id);
    }

    @Override
    public Boolean isAgent() {
        return ServiceFactory.getService(getSession()).isAgent();
    }

    @Override
    public Boolean isLoggedIn(){
        return ServiceFactory.getService(getSession()).isLoggedIn();
    }

    @Override
    public void adminCreationIfDoNotExist() {
        ServiceFactory.getService(getSession()).adminCreationIfDoNotExist();
        ServiceFactory.getService(getSession()).createPrivateGroupIfDoNotExist();
    }

    @Override
    public EntitiesList getSkills() {

        RefcompSession session = getSession();

        String userId = null;
        
        WikittyUser user = session.getUser();
        if (user != null) {
            userId = user.getWikittyId();
        }

        return ServiceFactory.getService(session).getSkills(userId);
    }

    @Override
    public EntitiesList getSkills(String agentId) {
        return ServiceFactory.getService(getSession()).getSkills(agentId);
    }

    @Override
    public AgentSkill addSkill() {

        RefcompSession session = getSession();

        WikittyUser user = session.getUser();

        return ServiceFactory.getService(session).addSkill(user.getWikittyId());
    }

    @Override
    public EntitiesList addSkill(Skill skill, String frequencyId) {

        RefcompSession session = getSession();

        WikittyUser user = session.getUser();

        return ServiceFactory.getService(session).addSkill(user.getWikittyId(),
                skill, frequencyId);
    }

    @Override
    public void removeSkill(String skillId) {
        ServiceFactory.getService(getSession()).removeSkill(skillId);
    }

    @Override
    public EntitiesList saveMySkills(List<AgentSkill> skills)
            throws InvalidEntityException{
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).saveMySkills(locale,
                skills);
    }

    @Override
    public AgentSkill getAgentSkill(String skillId) {
        return ServiceFactory.getService(getSession()).getAgentSkill(skillId);
    }

    /**
     * Get the logged in User
     * @return the logged in User
     */
    @Override
    public User getLoggedInUser() {

        RefcompSession session = getSession();

        WikittyUser user = session.getUser();
        String userId = null;
        fr.inra.refcomp.services.StorageService service = ServiceFactory.getService(getSession());
        if (user != null) {
            userId = user.getWikittyId();
        } else {
            WikittyUser loggedInUser = service.getLoggedInUser();
            if (loggedInUser != null) {
                session.setUser(loggedInUser);
                userId = loggedInUser.getWikittyId();
            }
        }


        return service.getUser(userId);
    }

    @Override
    public Agent getLoggedInAgent() {
        RefcompSession session = getSession();

        WikittyUser user = session.getUser();
        String userId = null;
        if (user != null) {
            userId = user.getWikittyId();
        }

        return ServiceFactory.getService(getSession()).getAgent(userId);
    }

    @Override
    public void setAdmin(String agentId, boolean admin) {
        ServiceFactory.getService(getSession()).setAdmin(agentId, admin);
    }

    @Override
    public EntitiesList searchUser(String search, String cati,
                                      String department, String unit,
                                      String frequency) {
        return ServiceFactory.getService(getSession()).searchUser(search,
                cati, department ,unit, frequency);
    }

    @Override
    public EntitiesList searchSkill(String search, String cati,
                                       String department, String unit,
                                       String frequency) {
        return ServiceFactory.getService(getSession()).searchSkill(search,
                cati, department ,unit, frequency);
    }

    @Override
    public String getPath(String id) {
        return ServiceFactory.getService(getSession()).getPath(id);
    }

    @Override
    public void setPrivateSkills(List<String> ids) {
        ServiceFactory.getService(getSession()).setPrivateSkills(ids);
    }

    @Override
    public void setPublicSkills(List<String> ids) {
        ServiceFactory.getService(getSession()).setPublicSkills(ids);
    }

    @Override
    public boolean moveSkill(String destination, String node) {
        return ServiceFactory.getService(getSession()).moveSkill(
                destination, node);
    }

    public boolean sendPassword(String userId) {
        Locale locale = getLocale();
        RefcompSession session = getSession();
        return ServiceFactory.getService(session).sendPassword(locale, userId);
    }

    @Override
    public Map<String, Skill> getRootSkill(List<String> skills) {
        return ServiceFactory.getService(getSession()).getRootSkill(skills);
    }

    @Override
    public List<Skill> getAllSkills() {
        return ServiceFactory.getService(getSession()).getAllSkills();
    }

    /**
     * Get the RefcompSession from the user session
     *
     * @return the user's session
     */
    protected RefcompSession getSession(){
        HttpServletRequest request = this.getThreadLocalRequest();
        return RefcompSession.getSession(request);
    }

    protected Locale getLocale(){
        HttpServletRequest request = this.getThreadLocalRequest();
        Locale locale = request.getLocale();
        return locale;
    }
}
