/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: StorageServiceAsync.java 139 2011-03-22 17:11:05Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.4/refcomp-client/src/main/java/fr/inra/refcomp/client/services/StorageServiceAsync.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.services;

import com.google.gwt.user.client.rpc.AsyncCallback;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.AgentSkill;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Skill;
import fr.inra.refcomp.entities.Unit;
import fr.inra.refcomp.entities.User;
import fr.inra.refcomp.services.AlreadyExistingException;
import java.util.List;
import fr.inra.refcomp.entities.Cati;
import java.util.Map;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
public interface StorageServiceAsync {

    void login(String login, String password, AsyncCallback<Boolean> callback);

    void logout(AsyncCallback<Void> callback);

    void getUsers(AsyncCallback<List<User>> callback);

    void saveUser(User user, String context, AsyncCallback<User> callback);

    void createUser(AsyncCallback<User> callback);

    void getUser(String id, AsyncCallback<User> callback);

    void getAgent(String id, AsyncCallback<Agent> callback);

    void getAgentAndDependencies(String id, AsyncCallback<EntitiesList> callback);

    void setAgent(User user, AsyncCallback<Agent> callback);

    void unsetAgent(String id, AsyncCallback<Void> callback);

    void saveAgent(Agent agent, String context, AsyncCallback<Agent> callback);

    void deleteUser(User user, AsyncCallback<Void> callback);

    void getFrequencies(AsyncCallback<List<Frequency>> callback);

    void saveFrequency(Frequency frequency, AsyncCallback<Frequency> callback);

    void createFrequency(AsyncCallback<Frequency> callback);

    void getFrequency(String id, AsyncCallback<Frequency> callback);

    void deleteFrequency(Frequency frequency, boolean force,
                         AsyncCallback<Void> callback);

    void getCatis(AsyncCallback<List<Cati>> callback);

    void saveCati(Cati cati, AsyncCallback<Cati> callback);

    void createCati(AsyncCallback<Cati> callback);

    void getCati(String id, AsyncCallback<Cati> callback);

    void deleteCati(Cati cati, AsyncCallback<Void> callback);

    void getChildrenSkill(String id, AsyncCallback<List<Skill>> callback);

    void saveSkill(Skill skill, AsyncCallback<Skill> callback);

    void createSkill(String parentId, AsyncCallback<Skill> callback);

    void getSkill(String id, AsyncCallback<Skill> callback);

    void deleteSkill(Skill skill, AsyncCallback<Void> callback);

    void saveUnit(Unit unit, AsyncCallback<Unit> callback)
            throws AlreadyExistingException;

    void saveUnit(Unit unit, List<String> departments,
                  AsyncCallback<Unit> callback);

    void createUnit(AsyncCallback<Unit> callback);

    void getUnit(String id, AsyncCallback<Unit> callback);

    void deleteUnit(Unit unit, AsyncCallback<Void> callback);

    void getUnits(AsyncCallback<List<Unit>> callback);

    void getUnits(String id, AsyncCallback<List<Unit>> callback);

    void saveDepartment(Department department, AsyncCallback<Department> callback);

    void saveDepartment(Department department, List<String> units,
                        AsyncCallback<Department> callback);

    void createDepartment(AsyncCallback<Department> callback);

    void getDepartment(String id, AsyncCallback<Department> callback);

    void deleteDepartment(Department department, AsyncCallback<Void> callback);

    void getDepartments(AsyncCallback<List<Department>> callback);

    void getDepartments(String id, AsyncCallback<List<Department>> callback);

    void getAdminEmail(AsyncCallback<String> callback);

    void isAdmin(AsyncCallback<Boolean> callback);

    void isAdmin(String id, AsyncCallback<Boolean> callback);

    void isAgent(AsyncCallback<Boolean> callback);

    void isLoggedIn(AsyncCallback<Boolean> callback);

    void adminCreationIfDoNotExist(AsyncCallback<Void> callback);

    void getSkills(AsyncCallback<EntitiesList> callback);

    void getSkills(String agentId, AsyncCallback<EntitiesList> callback);

    void addSkill(AsyncCallback<AgentSkill> callback);

    void addSkill(Skill skill, String frequencyId,
                        AsyncCallback<EntitiesList> callback);

    void removeSkill(String skillId, AsyncCallback<Void> callback);

    void saveMySkills(List<AgentSkill> skills, AsyncCallback<EntitiesList> callback);

    void getAgentSkill(String skillId, AsyncCallback<AgentSkill> callback);

    void getLoggedInUser(AsyncCallback<User> callback);

    void getLoggedInAgent(AsyncCallback<Agent> callback);

    void setAdmin(String agentId, boolean admin, AsyncCallback<Void> callback);

    void searchUser(String search, String cati, String department, String unit,
                String frequency, AsyncCallback<EntitiesList> callback);

    void searchSkill(String search, String cati, String department, String unit,
                String frequency, AsyncCallback<EntitiesList> callback);

    void getPath(String id, AsyncCallback<String> callback);

    void setPrivateSkills(List<String> ids, AsyncCallback<Void> callback);

    void setPublicSkills(List<String> ids, AsyncCallback<Void> callback);

    void moveSkill(String destination, String node, AsyncCallback<Boolean> callback);

    void sendPassword(String userId, AsyncCallback<Boolean> callback);

    void getRootSkill(List<String> skills, AsyncCallback<Map<String,Skill>> callback);

    void getAllSkills(AsyncCallback<List<Skill>> callback);


}
