/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: RefComp.java 209 2011-07-22 15:28:45Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.3/refcomp-client/src/main/java/fr/inra/refcomp/client/RefComp.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.admin.cati.AdminCati;
import fr.inra.refcomp.client.admin.departments.AdminDepartments;
import fr.inra.refcomp.client.admin.frequencies.AdminFrequencies;
import fr.inra.refcomp.client.admin.importexport.ImportExport;
import fr.inra.refcomp.client.admin.skills.AdminSkills;
import fr.inra.refcomp.client.admin.skills.PrintSkills;
import fr.inra.refcomp.client.admin.units.AdminUnits;
import fr.inra.refcomp.client.admin.users.AdminUsers;
import fr.inra.refcomp.client.agent.SkillsTableScreen;
import fr.inra.refcomp.client.constants.Footer;
import fr.inra.refcomp.client.constants.Header;
import fr.inra.refcomp.client.constants.HistoryUtil;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.client.user.AgentSearchResults;
import fr.inra.refcomp.client.user.MyAccount;
import fr.inra.refcomp.client.user.Search;
import fr.inra.refcomp.client.user.SearchResults;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.AgentSkill;
import fr.inra.refcomp.entities.EntitiesList;
import java.util.Map;
import org.nuiton.web.gwt.misc.LoaderNotification;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class RefComp implements EntryPoint, ValueChangeHandler<String> {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    protected static boolean loggedIn = false;
    public static final String CONTENT_STYLE = "clearfix content-text";
    public static final String CONTENT = "content";
    public static final String HEADER = "header";
    public static final String MENU = "left-sidebar";
    public static final String FOOTER = "footer";
    public static final String HOME = "home";
    public static final String LOGIN = "login";
    public static final String SEARCH = "search";
    public static final String MY_SKILLS = "mySkills";
    public static final String MY_ACCOUNT = "myAccount";
    public static final String MY_SHEET = "mySheet";
    public static final String CONTENT_HOME = "clearfix content-text home";
    public static final String CONTENT_IMPRESSION = "clearfix content-text impression";
    public static final String HELLO = "hello";

    public void onModuleLoad() {

        //Silent admin creation if it does not exist.
        service.adminCreationIfDoNotExist(new RefcompCallBack<Void>() {
            @Override
            public void onSuccess(Void result) {
                //do nothing
            }
        });

        RootPanel.get(HEADER).add(new Header());
        RootPanel.get(MENU).add(new Menu());
        RootPanel.get(FOOTER).add(new Footer());

        // If the application starts with no history token, start it off in the
        // ‘home’ state.
        String initToken = History.getToken();
        if (initToken.length() == 0) {
            History.newItem(HOME);
        }

        // Add history listener
        History.addValueChangeHandler(this);

        // Now that we've setup our listener, fire the initial history state.
        History.fireCurrentHistoryState();
    }

    public static boolean isLoggedIn(){
        return loggedIn;
    }

    public static void logIn(){
        loggedIn = true;
    }

    public static void logOut(){
        service.logout(new RefcompCallBack<Void>() {
            @Override
            public void onSuccess(Void result) {
                Menu.logOut();
                RootPanel.get(HELLO).clear();
            }

            @Override
            public void onFailure(Throwable exception) {
                Menu.logOut();
                RootPanel.get(HELLO).clear();
            }
        });

        loggedIn = false;
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        String historyToken = event.getValue();

        Menu.clearMenuStyle();

        //reload Home page
        if (historyToken.equals(HOME)) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_HOME);
            RootPanel.get(CONTENT).add(new Home());
            Menu.homeCurrent();
        }

        //reload Login page
        if (historyToken.equals(LOGIN)) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new Login());
            Menu.loginCurrent();
        }

        //Reload the search page
        if (historyToken.equals(SEARCH)) {
            RootPanel content = RootPanel.get(CONTENT);
            content.clear();
            content.setStyleName(CONTENT_STYLE);
            content.add(new Search());
            Menu.searchCurrent();
        }

        //Reload mySkills page
        if (historyToken.equals(MY_SKILLS)) {
            LoaderNotification.openLoaderPanel();

            add(CONTENT_STYLE, new SkillsTableScreen(true));
            //RootPanel.get(CONTENT).clear();
            //RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            //RootPanel.get(CONTENT).add(new SkillsTableScreen(true));
            Menu.mySkillsCurrent();
        }

        //Reload the user account edition
        if (historyToken.equals(MY_ACCOUNT)) {
            RootPanel content = RootPanel.get(CONTENT);
            content.clear();
            content.setStyleName(CONTENT_STYLE);
            content.add(new MyAccount());
            Menu.myAccountCurrent();
        }

        //reload mySheet page
        if(historyToken.equals(MY_SHEET)) {
            service.getLoggedInAgent(new RefcompCallBack<Agent>() {
                @Override
                public void onSuccess(Agent result) {
                    if (result != null) {
                        RootPanel content = RootPanel.get(CONTENT);

                        content.clear();
                        content.setStyleName(CONTENT_STYLE);
                        content.add(new SkillsTableScreen(result.getWikittyId()));
                        Menu.mySheetCurrent();
                    }
                }
            });
        }

        //reload adminSkills page
        if (historyToken.equals("adminSkills")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminSkills());
            Menu.adminSkillsCurrent();
        }

        //reload adminFrequencies page
        if (historyToken.equals("adminFrequencies")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminFrequencies());
            Menu.adminFrequenciesCurrent();
        }

        //reload adminCati page
        if (historyToken.equals("adminCati")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminCati());
            Menu.adminCatiCurrent();
        }

        //reload adminDepartments page
        if (historyToken.equals("adminDepartments")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminDepartments());
            Menu.adminDepartmentsCurrent();
        }

        //reload adminUnits page
        if (historyToken.equals("adminUnits")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminUnits());
            Menu.adminUnitsCurrent();
        }

        //reload adminUsers page
        if (historyToken.equals("adminUsers")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new AdminUsers());
            Menu.adminUsersCurrent();
        }

        //reload skills tree page (for impression)
        if (historyToken.equals("printSkills")) {
            LoaderNotification.openLoaderPanel();
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_IMPRESSION);
            RootPanel.get(CONTENT).add(new PrintSkills());
            Menu.adminPrintSkillsCurrent();
        }

        //reload import/export page
        if (historyToken.equals("import")) {
            RootPanel.get(CONTENT).clear();
            RootPanel.get(CONTENT).setStyleName(CONTENT_STYLE);
            RootPanel.get(CONTENT).add(new ImportExport());
            Menu.adminImportExportCurrent();
        }

        //reload search skills results
        if(historyToken.startsWith("searchSkills")) {

            LoaderNotification.openLoaderPanel();

            Map<String,String> parameters = HistoryUtil.parseHistoryToken(historyToken);

            final String search = parameters.get(SEARCH);
            final String catiFilter = parameters.get("cati");
            final String departmentFilter = parameters.get("department");
            final String unitFilter = parameters.get("unit");
            final String frequencyFilter = parameters.get("frequency");

            service.searchSkill(search, catiFilter,
                    departmentFilter, unitFilter, frequencyFilter,
                    new RefcompCallBack<EntitiesList>() {
                        @Override
                        public void onSuccess(EntitiesList result) {
                            RootPanel content = RootPanel.get(CONTENT);
                            switch (result.getEntities().size()) {
                                case 0:
                                    content.clear();
                                    content.add(new Search(URL.decodeQueryString(search), catiFilter,
                                            departmentFilter, unitFilter,
                                            frequencyFilter, true));

                                    break;
                                case 1:
                                    //String wId = result.getEntities().get(0).getWikittyId();
                                    AgentSkill agentSkill = (AgentSkill)result.getEntities().get(0);
                                    content.clear();
                                    content.add(new SkillsTableScreen(agentSkill.getAgent()));
                                    break;
                                default:
                                    content.clear();
                                    content.add(new SearchResults(
                                            search, result));
                                    break;
                            }
                        }
                    });

        }

        //reload search users results
        if (historyToken.startsWith("searchUsers")) {

            LoaderNotification.openLoaderPanel();

            Map<String, String> parameters = HistoryUtil.parseHistoryToken(historyToken);

            final String search = parameters.get(SEARCH);
            final String catiFilter = parameters.get("cati");
            final String departmentFilter = parameters.get("department");
            final String unitFilter = parameters.get("unit");

            service.searchUser(search, catiFilter,
                    departmentFilter, unitFilter, null,
                    new RefcompCallBack<EntitiesList>() {
                        @Override
                        public void onSuccess(EntitiesList result) {
                            switch (result.getEntities().size()) {
                                case 0:
                                    add(CONTENT_STYLE, new Search(search,
                                            catiFilter, departmentFilter,
                                            unitFilter, null, true));

                                    break;
                                case 1:
                                    Agent agent = (Agent) result.getEntities().get(0);
                                    add(CONTENT_STYLE, new SkillsTableScreen(
                                            agent.getWikittyId()));
                                    break;
                                default:
                                    add(CONTENT_STYLE, new AgentSearchResults(
                                            search, result));
                                    break;
                            }
                        }
                    });

        }

        //reload search users results
        if (historyToken.startsWith("agentSheet")) {
            LoaderNotification.openLoaderPanel();
            Map<String, String> parameters = HistoryUtil.parseHistoryToken(historyToken);

            String agent = parameters.get("agent");

            add(CONTENT_STYLE, new SkillsTableScreen(agent));
        }
    }

    protected void add(String contentStyle, Composite page) {
        RootPanel content = RootPanel.get(CONTENT);
        content.clear();
        content.setStyleName(contentStyle);
        content.add(page);
    }
}
