/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminSkills.java 163 2011-05-06 09:00:45Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.0/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/skills/AdminSkills.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.skills;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Skill;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.services.StorageService;
import org.nuiton.web.gwt.misc.BlindedPopup;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
public class AdminSkills extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("AdminSkills.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminSkills> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    static FlowPanel treePanel;

    protected static Tree skillsTree;

    @UiField
    Form form;

    @UiField
    ScrollPanel scrollPanel;

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {


        TreeItem treeItem = skillsTree.getSelectedItem();

        Skill parent = null;

        if (treeItem != null){
            parent = (Skill) treeItem.getUserObject();
        }

        String parentId = null;

        if (parent != null){
            parentId = parent.getWikittyId();
        }

        service.createSkill(parentId, new RefcompCallBack<Skill>() {
            @Override
            public void onSuccess(Skill result) {
                form.setContent(result, true);
            }
        });
    }

    @UiHandler("removeSelection")
    void doClickRemoveSelection(ClickEvent event) {

        skillsTree.setSelectedItem(null, true);
        form.clearContent();
    }

    @UiHandler("moveSelection")
    void doClickMoveSelection(ClickEvent event) {

        TreeItem item = skillsTree.getSelectedItem();

        if(item != null) {
            Skill value = (Skill) item.getUserObject();

            new BlindedPopup(new MoveTreeSelection(value.getWikittyId()));
        }
    }

    public AdminSkills() {
        initWidget(binder.createAndBindUi(this));

        //scrollPanel.setWidth("400px");

        AdminUtil.checkAdmin();

        GreenTree greenTree= new GreenTree();
        skillsTree = new Tree(greenTree, true);

        treePanel.clear();
        treePanel.add(skillsTree);

        //Tree loading at display
        TreeItem root = new TreeItem("Loading...");
        skillsTree.addItem(root);
        service.getChildrenSkill(null, new TreeRootCallback(skillsTree));
        skillsTree.addOpenHandler(new OpenHandler<TreeItem>() {
            public void onOpen(OpenEvent event) {
                if (needsLoading((TreeItem)event.getTarget())) {

                    Skill parentSkill = (Skill)((TreeItem)event.getTarget()).getUserObject();

                    service.getChildrenSkill(parentSkill.getWikittyId(),
                    new TreeItemCallback((TreeItem)event.getTarget()));
                }
            }

        });

        skillsTree.addSelectionHandler(new SelectionHandler<TreeItem>(){
            public void onSelection(SelectionEvent<TreeItem> event) {
                Skill editedBean = (Skill)skillsTree.getSelectedItem().getUserObject();

                form.setContent(editedBean, false);
            }
        });



        SkillForm skillForm = new SkillForm();

        form.setContentPanel(skillForm);
    }

    protected static boolean needsLoading(TreeItem item) {
        return item.getChildCount() == 1
                && "Loading...".equals(item.getChild(0).getText());
    }

    public static void refreshSelectedNode() {

        final TreeItem item = skillsTree.getSelectedItem();

        skillsTree.setSelectedItem(null, true);

        Skill skill = (Skill) item.getUserObject();

        service.getSkill(skill.getWikittyId(), new RefcompCallBack<Skill>(){
            @Override
            public void onSuccess (Skill result){
                item.setText(result.getName());
                item.setUserObject(result);
            }
        });
    }

    public static void removeSelectedNode() {

        TreeItem item = skillsTree.getSelectedItem();

        item.remove();
    }

    public static void addToSelectedNode(Skill skill) {

        TreeItem item = skillsTree.getSelectedItem();

        TreeItem child = new TreeItem();
        child.setText(skill.getName());
        child.setUserObject(skill);

        if (item != null){
            item.addItem(child);
        } else {
            skillsTree.addItem(child);
        }
    }

}
