/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.matrix;

import fr.ifremer.isisfish.util.matrix.EntitySemanticsDecorator;
import fr.ifremer.isisfish.util.matrix.SimpleParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class MatrixCSVHelper {
    private static Log log = LogFactory.getLog(MatrixCSVHelper.class);
    protected EntitySemanticsDecorator decorator;

    public MatrixCSVHelper() {
        this(new EntitySemanticsDecorator());
    }

    public MatrixCSVHelper(EntitySemanticsDecorator decorator) {
        this.decorator = decorator;
    }

    protected MatrixFactory getMatrixFactory() {
        return MatrixFactory.getInstance();
    }

    protected List<String> undecorate(List l) {
        ArrayList<String> result = new ArrayList<String>(l.size());
        for (Object o : l) {
            result.add(this.undecorate(o));
        }
        return result;
    }

    protected String undecorate(Object o) {
        return this.decorator.undecorate(o);
    }

    public MatrixND readMatrix(String mat) throws IOException {
        try (StringReader in = new StringReader(mat);){
            MatrixND result;
            MatrixND matrixND = result = this.readMatrix(in);
            return matrixND;
        }
    }

    public String writeMatrix(String name, MatrixND mat) throws IOException {
        try (StringWriter out = new StringWriter();){
            String result;
            this.writeMatrix(out, name, mat);
            String string = result = out.toString();
            return string;
        }
    }

    public MatrixND readMatrix(Reader reader) throws IOException {
        LineNumberReader in = new LineNumberReader(reader);
        SimpleParser sp = new SimpleParser(in, true);
        String name = sp.readString('\n');
        ArrayList<String> dimNames = new ArrayList<String>();
        ArrayList semantics = new ArrayList();
        String dimName = sp.readString(':');
        while (!sp.isEOL() || StringUtils.isNotBlank((CharSequence)dimName)) {
            dimNames.add(dimName);
            ArrayList<String> sems = new ArrayList<String>();
            semantics.add(sems);
            while (!sp.isEOL()) {
                String sem = sp.readString(';');
                sems.add(sem);
            }
            dimName = sp.readString(':');
        }
        MatrixND result = this.getMatrixFactory().create(name, semantics.toArray(new List[0]), dimNames.toArray(new String[0]));
        int nbDim = dimNames.size();
        int[] coord = new int[nbDim];
        while (!sp.isEOF()) {
            for (int i = 0; i < nbDim; ++i) {
                coord[i] = sp.readInt(';');
            }
            double v = sp.readDouble(';');
            result.setValue(coord, v);
        }
        return result;
    }

    public void writeMatrix(Writer writer, String name, MatrixND mat) {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        out.print(name);
        out.println();
        List[] sems = mat.getSemantics();
        int maxi = sems.length;
        for (int i = 0; i < maxi; ++i) {
            String dimName = mat.getDimensionName(i);
            out.print(dimName);
            List<String> l = this.undecorate(sems[i]);
            int sep = 58;
            for (String o : l) {
                out.print((char)sep);
                out.print((Object)o);
                sep = 59;
            }
            out.println();
        }
        out.println();
        MatrixIterator i = mat.iteratorNotZero();
        while (i.hasNext()) {
            i.next();
            int[] pos = i.getCoordinates();
            double value = i.getValue();
            for (int p : pos) {
                out.print(p);
                out.print(';');
            }
            out.print(value);
            out.println();
        }
        out.flush();
    }
}

