/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.spatial;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.MapDataProvider;
import java.util.ArrayList;
import java.util.List;

public class SpatialChangeDataProvider
extends MapDataProvider {
    protected FisheryRegion fisheryRegion;
    protected List<Cell> cells;

    public SpatialChangeDataProvider(FisheryRegion fisheryRegion, List<Cell> cells) {
        this.fisheryRegion = fisheryRegion;
        this.cells = cells;
    }

    @Override
    public float getMinLongitude() {
        return this.fisheryRegion.getMinLongitude();
    }

    @Override
    public float getMaxLongitude() {
        return this.fisheryRegion.getMaxLongitude();
    }

    @Override
    public float getMinLatitude() {
        return this.fisheryRegion.getMinLatitude();
    }

    @Override
    public float getMaxLatitude() {
        return this.fisheryRegion.getMaxLatitude();
    }

    @Override
    public float getCellLengthLongitude() {
        return this.fisheryRegion.getCellLengthLongitude();
    }

    @Override
    public float getCellLengthLatitude() {
        return this.fisheryRegion.getCellLengthLatitude();
    }

    @Override
    public List<Cell> getCell() {
        return this.cells;
    }

    @Override
    public List<String> getMapFilePath() {
        return this.fisheryRegion.getMapFilePath();
    }

    @Override
    public List<Cell> findAllByCoordinates(float latitude, float longitude) {
        ArrayList<Cell> filteredCells = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (cell.getLatitude() != latitude || cell.getLongitude() != longitude) continue;
            filteredCells.add(cell);
        }
        return filteredCells;
    }
}

