/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class SensitivityCatchWeightY1
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivityCatchWeightY1.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP};
    @Doc(value="Population")
    public Population param_pop;

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        ResultStorage resultStorage = simulation.getResultStorage();
        TimeStep lastStep = resultStorage.getLastStep();
        Double capturesWeight = 0.0;
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            int i = 0;
            while (i < 12) {
                MatrixND matlastdate = resultStorage.getMatrix(new TimeStep(lastStep.getStep() - i), pop, ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP);
                capturesWeight = capturesWeight + matlastdate.sumAll();
                ++i;
            }
        }
        out.write(Double.toString(capturesWeight));
    }

    public String getDescription() {
        return "Captures in weight for the last year for the popage population. Captures is the sum of zones, groups, metiers and strategies";
    }

    public String getExportFilename() {
        return "SensitivityCapturesWeightY1_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

