/*
 * Decompiled with CFR 0.152.
 */
package exports;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class Biomasses
implements Export {
    private static Log log = LogFactory.getLog(Biomasses.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getExportFilename() {
        return "Biomasses";
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String getDescription() {
        return "Exporte les biomasses tableau avec des lignes pop;id;zone;date;nombre";
    }

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        for (Population pop : simulation.getParameter().getPopulations()) {
            MatrixND mat = simulation.getResultStorage().getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i = mat.iterator();
            while (i.hasNext()) {
                i.next();
                Object[] sems = i.getSemanticsCoordinates();
                TimeStep step = (TimeStep)sems[0];
                PopulationGroup group = (PopulationGroup)sems[1];
                Zone zone = (Zone)sems[2];
                double val = i.getValue();
                out.write(String.valueOf(pop.getName()) + ";" + group.getId() + ";" + zone.getName() + ";" + step.getStep() + ";" + val + "\n");
            }
        }
    }
}

