/*
 * #%L
 * Coser :: Web
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin, Chatellier Eric, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.common;

import fr.ifremer.coser.result.CoserRequest;

import java.util.Map;

/**
 * Recupere la liste des indicateurs à partir d'une zone et d'une espece (peut
 * être null dans le cas des communautés).
 *
 * @author chatellier
 * @version $Revision$
 *          <p/>
 *          Last update : $Date$
 *          By : $Author$
 */
public abstract class CommonIndicator extends AbstractCoserJspAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    protected String facade;

    protected String zone;

    protected String zonePicture;

    protected Map<String, String> indicators;

    /**
     * @return the request to get zones
     */
    protected abstract CoserRequest createZonesRequest();

    /**
     * @return the request to get indicators
     */
    protected abstract CoserRequest createIndicatorsRequest();

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Map<String, String> getIndicators() {
        return indicators;
    }

    public String getZonePicture() {
        return zonePicture;
    }

    public String getFacadeDisplayName() {
        return getService().getFacadeDisplayName(facade);
    }

    public String getZoneDisplayName() {
        CoserRequest zonesRequest = createZonesRequest();
        return getService().getZoneDisplayName(zonesRequest, zone);
    }

    @Override
    public String execute() {

        CoserRequest request = createIndicatorsRequest();
        indicators = getService().toMap(request);
        zonePicture = getService().getZonePictures().get(zone);

        return SUCCESS;
    }

//      public String getFacadeDisplayName() {
//        WebService webService = ServiceFactory.getWebService();
//        String displayName = null;
//        try {
//            displayName = webService.getFacades().get(facade);
//        } catch (CoserBusinessException ex) {
//            throw new CoserWebException("Can't get facade display name", ex);
//        }
//        return displayName;
//    }
//
//    public String getZoneDisplayName() {
//        WebService webService = ServiceFactory.getWebService();
//        String displayName = null;
//        try {
//            displayName = webService.getZoneForFacade(facade, false, false).get(zone);
//        } catch (CoserBusinessException ex) {
//            throw new CoserWebException("Can't get zone display name", ex);
//        }
//        return displayName;
//    }
//
//    public String getSpeciesDisplayName() {
//        WebService webService = ServiceFactory.getWebService();
//        String displayName = null;
//        try {
//            displayName = webService.getSpecies(zone, false).get(species);
//        } catch (CoserBusinessException ex) {
//            throw new CoserWebException("Can't get species display name", ex);
//        }
//        return displayName;
//    }
//    @Override
//    public String execute() {
//
//        if (log.isInfoEnabled()) {
//            log.info(String.format("Looking for indicator for zone %s and species %s", zone, species));
//        }
//
//        WebService webService = ServiceFactory.getWebService();
//
//        Locale locale = getLocale();
//
//        try {
//            indicators = webService.getIndicators(zone, species, locale);
//
//            zonePicture = webService.getZonePictures().get(zone);
//        } catch (CoserBusinessException ex) {
//            throw new CoserWebException("Can't get indicators", ex);
//        }
//
//        return SUCCESS;
//    }
}
