/*
 * #%L
 * $Id: ZoneAction.java 1033 2012-08-09 10:36:21Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/ZoneAction.java $
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import java.util.Locale;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CommonZone;

/**
 * Affiche la liste des sous zones (zone).
 * 
 * @author chatellier
 * @version $Revision: 1033 $
 * 
 * Last update : $Date: 2012-08-09 12:36:21 +0200 (Thu, 09 Aug 2012) $
 * By : $Author: echatellier $
 */
public class ZoneAction extends CommonZone {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        Locale locale = getLocale();

        try {
            // renvoi la liste des id subzone-survey et leurs label associé
            zones = webService.getZoneForFacade(facade, false, true);
            zonesPictures = webService.getZonePictures();
            zonesMetaInfo = webService.getZoneMetaInfo(locale);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", ex);
        }

        return SUCCESS;
    }
}
