package fr.ifremer.coser.ui.project;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ProjectOpenView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdm9iO80FCDElQAgpgCr7ORNAlgkBQFCyHRBihCDfs+TbxRue9ZXePHA3iJ/AToKdBoqNCFNQUNIi/gBAFLWL27mLnyJlYwsWePTvvzZvnmXvzHXJKwpkdEgSW9LlmbWpVb21urts7tKnvUNWUTGhPQvTJZCHbgGGnE1cazjVqBl6J4ZVlry08Tvk+9EINhpR+5lLVolRrOJVENJWq1DvXC4Hw5R5rR1Qa66ufP7IvnRevswCBQHWD2MrcYahuJwM1yDJHwwRWekoqLuHbKEMyvo16R01s2SVK3SNt+gSeQ6EGeUEkkmk423/LIUeID4SGQvkBsV16VcOlLWmxLUnbVFpNT+HpM0tIz/hubUTPdUH5Q0Z3hQgZ8ohvEe64VGq42Ad+NUreB4/Kz2uYTvikdrFrK7wzmcUOYLBcrRGbuih4wjgSxKlR1CSNHcidN7+PJ+9Gy9V6U3quu0G46X4qQda9SqJG4n5UjSl0/VhSAcZM3lQnvViu3va19jgWKCVyo3BMLmEm0TyOn9Udv+58ZBqQkz6G0a3GwYm9j1fRrE7/NauGMLz9PVn68v7bu5W9AS1g7ROpqfv2CwcH2xb4HzNTeiyaTl8zt7JGxEIDioq6aEq4fLMpwurxNYrDeqFploFbq0S1kCJX+Prh4+Tjz0cguwJDrkecFWLy70JRtyS64LlOIG4uhYpGdgfxHDfaNORtTzpm+I4uOkSTOZtxB/29EaAJsykmdJTYxU+/SvW3S3tGZFDYyZ7pXTNyjyDPuMs4DXc1XsPU3RwWivqO1123tAXMmOe4iBfifHheSOt0QNMAJ25iMao+RzS+GGxfU+zVgK6ETZhvlZCzdCinCV8zx+V0hsk+VOXanhNtXQ+SmT5IRqPxYR5fQ7b/JCtQbl4azj9oTvdvzfXeDH8Ab/fPLKoGAAA=";
    private static final Log log = LogFactory.getLog(ProjectOpenView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ProjectHandler handler;
    protected JList projectsList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private ProjectOpenView $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectOpenView() {
        $initialize();
    }

    public ProjectOpenView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().loadProject(this);
    }

    public void doMouseClicked__on__projectsList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().loadProjectOnDoubleClick(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectHandler getHandler() {
        return handler;
    }

    public JList getProjectsList() {
        return projectsList;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(ProjectHandler handler) {
        ProjectHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createProjectsList() {
        $objectMap.put("projectsList", projectsList = new JList());
        
        projectsList.setName("projectsList");
        projectsList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__projectsList"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(projectsList);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(t("coser.ui.project.openProjectTitle")));
        $JLabel1.setText(t(getContextValue(fr.ifremer.coser.CoserConfig.class).getRSufiProjectsDirectory().getAbsolutePath() + java.io.File.separator));
        projectsList.setModel(new fr.ifremer.coser.ui.project.ProjectNamesListModel(this));
        projectsList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("coser.ui.project.project"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createProjectsList();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.project.openProject"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (projectsList != null) {
                    $bindingSources.put("projectsList.getSelectionModel()", projectsList.getSelectionModel());
                    projectsList.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    projectsList.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectOpenView.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (projectsList != null) {
                    $JButton0.setEnabled(projectsList.getSelectedIndex() >= 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (projectsList != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("projectsList.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    projectsList.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectOpenView.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}