/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.maps;

import com.bbn.openmap.layer.location.AbstractLocationHandler;
import com.bbn.openmap.layer.location.BasicLocation;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import fr.ifremer.coser.util.Coordinate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.List;

public class HaulLocationHandler
extends AbstractLocationHandler {
    protected static Color[] markerColors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GRAY, Color.BLACK, Color.GREEN, Color.GREEN.darker(), Color.MAGENTA, Color.PINK, Color.YELLOW, new Color(165, 3, 63)};
    protected List<Coordinate> coordinates;

    public HaulLocationHandler(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
        this.setShowLocations(true);
    }

    public OMGraphicList get(float nwLat, float nwLon, float seLat, float seLon, OMGraphicList graphicList) {
        for (Coordinate coordinate : this.coordinates) {
            int serie = coordinate.getSerie();
            String htmlName = "<html>" + coordinate.getName().replaceAll("\n", "<br>") + "</html>";
            BasicLocation location = new BasicLocation(coordinate.getLatitude(), coordinate.getLongitude(), htmlName, null);
            location.setLocationHandler((LocationHandler)this);
            location.getLocationMarker().setLinePaint((Paint)markerColors[serie %= markerColors.length]);
            graphicList.add((OMGraphic)location);
        }
        return graphicList;
    }

    public List<Component> getItemsForPopupMenu(Location arg0) {
        return null;
    }

    public void reloadData() {
    }
}

