/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.ui.control.ControlTableModel;
import fr.ifremer.coser.ui.control.ControlView;
import org.nuiton.i18n.I18n;

public class ControlDataTableModel
extends ControlTableModel {
    private static final long serialVersionUID = -1192463259386773117L;
    protected DataStorage data;
    protected CoserConstants.Category category;
    protected String[] header;

    public ControlDataTableModel(ControlView controlView, CoserConstants.Category category) {
        this.category = category;
        this.updateData(controlView);
    }

    @Override
    public CoserConstants.Category getCategory() {
        return this.category;
    }

    protected void updateData(ControlView controlView) {
        Project project = controlView.getContextValue(Project.class);
        switch (this.category) {
            case CATCH: {
                this.data = project.getControl().getCatch();
                break;
            }
            case HAUL: {
                this.data = project.getControl().getHaul();
                break;
            }
            case LENGTH: {
                this.data = project.getControl().getLength();
                break;
            }
            case STRATA: {
                this.data = project.getControl().getStrata();
            }
        }
        this.header = this.data.get(0);
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size() - 1;
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public String getColumnName(int column) {
        String name = this.header[column];
        if (column == 0) {
            name = I18n.t((String)name, (Object[])new Object[0]);
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = this.getDataAt(rowIndex)[columnIndex];
        return result;
    }

    @Override
    public String[] getDataAt(int rowIndex) {
        return this.data.get(rowIndex + 1);
    }

    @Override
    public int getRealIndexOfLine(String lineNumber) {
        int result = this.data.indexOf(lineNumber) - 1;
        return result;
    }
}

