/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.common;

import fr.ifremer.coser.ui.control.ControlHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CommonHandler {
    private static final Log log = LogFactory.getLog(ControlHandler.class);
    protected JFileChooser fileChooserInstance;

    protected JFileChooser getFileChooserInstance(File currentDirectory) {
        if (this.fileChooserInstance == null) {
            this.fileChooserInstance = new JFileChooser();
            this.fileChooserInstance.setCurrentDirectory(currentDirectory);
        }
        return this.fileChooserInstance;
    }

    public void setWaitCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void browseFile(Component parentComponent, File report) {
        try {
            Desktop.getDesktop().browse(report.toURI());
        }
        catch (IOException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't open generated report at " + report.getAbsolutePath()), (Throwable)ex);
            }
            JOptionPane.showMessageDialog(parentComponent, I18n.t((String)"coser.ui.error.htmlReportCantBeOpened", (Object[])new Object[]{report.getAbsolutePath()}), I18n.t((String)"coser.ui.error.htmlReportError", (Object[])new Object[0]), 2);
        }
    }
}

