/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.widgets;

import fr.ifremer.coser.ui.widgets.AccordionLayout;
import fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AccordionPane
extends JPanel {
    private static final long serialVersionUID = -4266521429712806753L;
    protected List<AccordionPaneSubPanel> children = new ArrayList<AccordionPaneSubPanel>();
    protected int selected = -1;
    protected int previouslySelected = -1;
    protected Color paneBackgroundColor;
    protected Color activePaneBackgroundColor;
    protected Timer timer;
    protected int transitionStep = 0;
    protected int remainder = -1;

    public AccordionPane() {
        this.setLayout(new AccordionLayout(this));
        this.paneBackgroundColor = super.getBackground();
        this.activePaneBackgroundColor = new Color(255, 255, 200);
    }

    public void setTitleBackgroundColors(Color normalColor, Color activeColor) {
        this.paneBackgroundColor = normalColor;
        this.activePaneBackgroundColor = activeColor;
        this.repaint();
    }

    public void add(AccordionPaneSubPanel subPanel) {
        subPanel.setAccordionPane(this);
        subPanel.setIndex(this.children.size());
        this.children.add(subPanel);
        super.add(subPanel);
    }

    @Override
    public void paint(Graphics g) {
        if (this.selected < 0 && this.children.size() > 0) {
            this.setSelected(0, false);
        }
        if (this.transitionStep >= this.remainder && this.remainder > 0 && this.timer != null) {
            this.timer.stop();
            this.timer = null;
            System.out.println("Killed timer.");
        }
        super.paint(g);
    }

    public void setSelected(int num) {
        this.setSelected(num, false);
    }

    public void setSelected(int num, boolean showAnimation) {
        if (num == this.selected) {
            return;
        }
        this.previouslySelected = !showAnimation ? -1 : this.selected;
        this.selected = num;
        for (int i = 0; i < this.children.size(); ++i) {
            AccordionPaneSubPanel subPanel = this.children.get(i);
            subPanel.titlePanel.setBackground(i == num ? this.activePaneBackgroundColor : this.paneBackgroundColor);
        }
        if (this.previouslySelected >= 0 && showAnimation) {
            ActionListener a = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccordionPane.this.transitionStep = AccordionPane.this.remainder - AccordionPane.this.transitionStep < 10 ? ++AccordionPane.this.transitionStep : (AccordionPane.this.remainder - AccordionPane.this.transitionStep < 25 ? (AccordionPane.this.transitionStep += 3) : (AccordionPane.this.transitionStep += 10));
                    if (AccordionPane.this.transitionStep >= AccordionPane.this.remainder) {
                        AccordionPane.this.transitionStep = -1;
                        AccordionPane.this.timer.stop();
                    } else {
                        AccordionPane.this.timer.setInitialDelay(1);
                        AccordionPane.this.timer.restart();
                    }
                    AccordionPane.this.doLayout();
                    AccordionPane.this.validate();
                    AccordionPane.this.repaint();
                }
            };
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.transitionStep = 0;
            this.timer = new Timer(1, a);
            this.timer.start();
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public int getPaneCount() {
        return this.children.size();
    }

    public void setTitleAt(int index, String newTitle) {
        AccordionPaneSubPanel subPanel = this.children.get(index);
        subPanel.titleLabel.setText(newTitle);
    }

    public String getTitleAt(int index) {
        AccordionPaneSubPanel subPanel = this.children.get(index);
        return subPanel.titleLabel.getText();
    }

    public void setIconAt(int index, Icon icon) {
        AccordionPaneSubPanel subPanel = this.children.get(index);
        subPanel.titleLabel.setIcon(icon);
    }

    public Component getComponentAt(int index) {
        AccordionPaneSubPanel subPanel = this.children.get(index);
        return subPanel.child;
    }

    public Component getSelectedComponent() {
        AccordionPaneSubPanel subPanel = this.children.get(this.selected);
        return subPanel.child;
    }
}

