/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.selection.replay;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.command.Command;
import fr.ifremer.coser.services.CommandService;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.ui.CoserFrame;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.common.SpeciesListRenderer;
import fr.ifremer.coser.ui.selection.replay.CommandListRenderer;
import fr.ifremer.coser.ui.selection.replay.SelectionByProjectTreeModel;
import fr.ifremer.coser.ui.selection.replay.SelectionReplayView;
import fr.ifremer.coser.ui.util.CoserListSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectionReplayHandler
extends CommonHandler {
    private static final Log log = LogFactory.getLog(SelectionReplayHandler.class);

    public void initReplayView(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        SortedMap selectionsByProject = projectService.getSelectionByProject();
        SelectionByProjectTreeModel treeModel = new SelectionByProjectTreeModel(selectionsByProject);
        view.getSelectionByProjectTree().setModel(treeModel);
        view.getCommandList().setCellRenderer(new CommandListRenderer(project));
    }

    public void validSelectionChoice(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        TreePath selectedSelection = view.getSelectionByProjectTree().getSelectionPath();
        try {
            this.setWaitCursor(view);
            String selectionName = (String)selectedSelection.getLastPathComponent();
            String projectName = (String)selectedSelection.getParentPath().getLastPathComponent();
            Selection replayedSelection = projectService.openSelection(projectName, selectionName);
            view.setReplayedSelection(replayedSelection);
            Selection selection = projectService.initProjectSelection(project);
            view.setSelection(selection);
            view.getValidatorSelection().setBean((Object)selection);
            view.getYearsListModel().setYears(selection.getAllYears());
            ((CoserListSelectionModel)((Object)view.getYearsList().getSelectionModel())).setSelectedObjects(replayedSelection.getSelectedYears());
            Collection remaindYear = CollectionUtils.subtract((Collection)replayedSelection.getSelectedYears(), (Collection)selection.getAllYears());
            if (!remaindYear.isEmpty()) {
                String yearsAsString = StringUtils.join((Iterable)remaindYear, (String)", ");
                String message = I18n._((String)"coser.ui.selection.replay.missingyears", (Object[])new Object[]{yearsAsString});
                view.getMessageArea2().setText(message);
            }
            view.getWizardLayout().show(view.getWizardPanel(), "step2");
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't load selection properties", ex);
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void validSelectionYears(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getSelection();
        Selection replayedSelection = view.getReplayedSelection();
        try {
            Collection remaindStrata;
            this.setWaitCursor(view);
            Object[] selectedDates = view.getYearsList().getSelectedValues();
            ArrayList<String> years = new ArrayList<String>(selectedDates.length);
            for (Object selectedDate : selectedDates) {
                years.add((String)selectedDate);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Refreshing strata list");
            }
            List strata = projectService.filterDataYearsAndGetStrata(project, selection, years);
            view.getStrataListModel().setStrata(strata);
            ((CoserListSelectionModel)((Object)view.getStrataList().getSelectionModel())).setSelectedObjects(replayedSelection.getSelectedStrata());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Strata list refreshed");
            }
            if (!(remaindStrata = CollectionUtils.subtract((Collection)replayedSelection.getSelectedStrata(), (Collection)strata)).isEmpty()) {
                String strataAsString = StringUtils.join((Iterable)remaindStrata, (String)", ");
                String message = I18n._((String)"coser.ui.selection.replay.missingstrata", (Object[])new Object[]{strataAsString});
                view.getMessageArea3().setText(message);
            }
            view.getWizardLayout().show(view.getWizardPanel(), "step3");
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't save selected years", ex);
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionStrata(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getSelection();
        Selection replayedSelection = view.getReplayedSelection();
        try {
            this.setWaitCursor(view);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Strata list selection changed, updating species list");
            }
            Object[] selectedStrata = view.getStrataList().getSelectedValues();
            ArrayList<String> strata = new ArrayList<String>(selectedStrata.length);
            for (Object selectedStratum : selectedStrata) {
                strata.add((String)selectedStratum);
            }
            projectService.filterDataStrata(project, selection, strata);
            List commands = replayedSelection.getHistoryCommands();
            if (CollectionUtils.isNotEmpty((Collection)commands)) {
                view.getCommandListModel().setCommands(commands);
                view.getWizardLayout().show(view.getWizardPanel(), "step4");
            } else {
                this.validSelectionCommand(view);
            }
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void validSelectionCommand(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        CommandService commandService = view.getContextValue(CommandService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getSelection();
        Selection replayedSelection = view.getReplayedSelection();
        try {
            this.setWaitCursor(view);
            List<Command> commands = view.getCommandListModel().getCommands();
            if (commands != null) {
                for (Command command : commands) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Replay command " + command));
                    }
                    commandService.doAction(command, project, (AbstractDataContainer)selection);
                }
            }
            LinkedHashMap reftaxSpecies = project.getRefTaxSpeciesMap();
            List currentSpecies = projectService.getProjectSpecies((AbstractDataContainer)selection, project, null);
            currentSpecies = CoserUtils.sortCollectionWithMapKeys((LinkedHashMap)reftaxSpecies, (Collection)currentSpecies);
            view.getSelectedSpeciesListModel().setSpecies(currentSpecies);
            view.getSelectedSpeciesList().setCellRenderer(new SpeciesListRenderer(reftaxSpecies));
            ((CoserListSelectionModel)((Object)view.getSelectedSpeciesList().getSelectionModel())).setSelectedObjects(replayedSelection.getSelectedSpecies());
            Collection remaindSpecies = CollectionUtils.subtract((Collection)replayedSelection.getSelectedSpecies(), (Collection)currentSpecies);
            if (!remaindSpecies.isEmpty()) {
                String separator = "";
                StringBuilder speciesBuilder = new StringBuilder(256);
                for (String species : remaindSpecies) {
                    speciesBuilder.append(separator);
                    speciesBuilder.append(project.getDisplaySpeciesText(species));
                    separator = ", ";
                }
                String message = I18n._((String)"coser.ui.selection.replay.missingspecies", (Object[])new Object[]{speciesBuilder.toString()});
                view.getMessageArea5().setText(message);
            }
            view.getWizardLayout().show(view.getWizardPanel(), "step5");
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't replay species merge command", ex);
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionSpecies(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getSelection();
        Selection replayedSelection = view.getReplayedSelection();
        try {
            this.setWaitCursor(view);
            Object[] selectedSpeciesArr = view.getSelectedSpeciesList().getSelectedValues();
            ArrayList<String> selectedSpecies = new ArrayList<String>(selectedSpeciesArr.length);
            for (Object selectedSingleSpecies : selectedSpeciesArr) {
                selectedSpecies.add((String)selectedSingleSpecies);
            }
            projectService.filterDataSpecies(project, selection, selectedSpecies);
            projectService.fillListsSelection(selection, replayedSelection.getSelectedSpeciesOccDens(), replayedSelection.getSelectedSpeciesSizeAllYear(), replayedSelection.getSelectedSpeciesMaturity());
            view.getWizardLayout().show(view.getWizardPanel(), "step6");
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionInfos(SelectionReplayView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getSelection();
        try {
            this.setWaitCursor(view);
            projectService.createProjectSelection(project, selection);
            CoserFrame parent = view.getContextValue(CoserFrame.class, "parent");
            parent.getHandler().showSelectionView(selection, 1);
            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.selection.selectionCreated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.replay.replayTitle", (Object[])new Object[0]), 1);
            view.dispose();
        }
        catch (CoserBusinessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save selection", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(view, ex.getMessage(), I18n._((String)"coser.ui.selection.saveError", (Object[])new Object[0]), 0);
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void finishSelection1toFinal(SelectionReplayView view) {
        this.validSelectionChoice(view);
        this.finishSelection2toFinal(view);
    }

    public void finishSelection2toFinal(SelectionReplayView view) {
        this.validSelectionYears(view);
        this.finishSelection3toFinal(view);
    }

    public void finishSelection3toFinal(SelectionReplayView view) {
        this.validSelectionStrata(view);
        this.finishSelection4toFinal(view);
    }

    public void finishSelection4toFinal(SelectionReplayView view) {
        this.validSelectionCommand(view);
        this.finishSelection5toFinal(view);
    }

    public void finishSelection5toFinal(SelectionReplayView view) {
        this.validSelectionSpecies(view);
    }
}

