/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.ui.CoserFrame;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.project.ProjectCreationView;
import fr.ifremer.coser.ui.project.ProjectEditView;
import fr.ifremer.coser.ui.project.ProjectOpenView;
import fr.ifremer.coser.util.ProgressMonitor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ProjectHandler
extends CommonHandler {
    private static final Log log = LogFactory.getLog(ProjectHandler.class);
    protected JFileChooser mapFileChooser;

    protected JFileChooser getMapFileChooser() {
        if (this.mapFileChooser == null) {
            this.mapFileChooser = new JFileChooser();
            this.mapFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().matches(".*\\.shp");
                }

                @Override
                public String getDescription() {
                    return "ESRI Shapefiles (*.shp)";
                }
            });
        }
        return this.mapFileChooser;
    }

    public void selectInputFile(ProjectCreationView projectView, JTextField textComponent) {
        CoserConfig config = projectView.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(0);
        int result = selectFileChooser.showOpenDialog((Component)((Object)projectView));
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void selectMapFiles(ProjectCreationView projectView) {
        JFileChooser selectFileChooser = this.getMapFileChooser();
        int result = selectFileChooser.showOpenDialog((Component)((Object)projectView));
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            projectView.getProjectMapsModel().addMap(selectedFile);
        }
    }

    public void removeSelectedMapFiles(ProjectCreationView projectView) {
        Object[] values;
        for (Object value : values = projectView.getProjectMaps().getSelectedValues()) {
            projectView.getProjectMapsModel().removeMap(value);
        }
    }

    public void selectMapFiles(ProjectEditView projectView) {
        JFileChooser selectFileChooser = this.getMapFileChooser();
        int result = selectFileChooser.showOpenDialog((Component)((Object)projectView));
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            projectView.getProjectMapsModel().addMap(selectedFile);
        }
    }

    public void removeSelectedMapFiles(ProjectEditView projectView) {
        Object[] values;
        for (Object value : values = projectView.getProjectMaps().getSelectedValues()) {
            projectView.getProjectMapsModel().removeMap(value);
        }
    }

    public void createProject(final ProjectCreationView projectView) {
        final CoserFrame parent = projectView.getContextValue(CoserFrame.class, "parent");
        CoserConfig config = projectView.getContextValue(CoserConfig.class);
        final Project project = projectView.getProject();
        String reftaxSpeciesPath = null;
        reftaxSpeciesPath = projectView.getCustomReferenceCheckBox().isSelected() ? projectView.getCustomReferenceSpeciesFileTextField().getText().trim() : config.getReferenceSpeciesPath();
        String codeTypeEspecePath = config.getReferenceTypeEspecesPath();
        File capturesFile = new File(project.getCatchFile());
        File stratesFile = new File(project.getStrataFile());
        File traitsFile = new File(project.getHaulFile());
        File taillesFile = new File(project.getLengthFile());
        File reftaxSpeciesFile = new File(reftaxSpeciesPath);
        File codeTypeEspeceFile = new File(codeTypeEspecePath);
        project.setCatchFileName(capturesFile.getName());
        project.setLengthFileName(taillesFile.getName());
        project.setHaulFileName(traitsFile.getName());
        project.setStrataFileName(stratesFile.getName());
        final List<File> newMaps = projectView.getProjectMapsModel().getMaps();
        if (!reftaxSpeciesFile.isFile()) {
            JOptionPane.showMessageDialog((Component)((Object)projectView), I18n._((String)"coser.ui.project.createProjectMissingReftax", (Object[])new Object[0]), I18n._((String)"coser.ui.project.missingFile", (Object[])new Object[0]), 0);
            return;
        }
        if (!codeTypeEspeceFile.isFile()) {
            JOptionPane.showMessageDialog((Component)((Object)projectView), I18n._((String)"coser.ui.project.createProjectMissingCodeTypeSpecies", (Object[])new Object[0]), I18n._((String)"coser.ui.project.missingFile", (Object[])new Object[0]), 0);
            return;
        }
        final HashMap<CoserConstants.Category, File> fileToLoad = new HashMap<CoserConstants.Category, File>();
        fileToLoad.put(CoserConstants.Category.CATCH, capturesFile);
        fileToLoad.put(CoserConstants.Category.HAUL, traitsFile);
        fileToLoad.put(CoserConstants.Category.LENGTH, taillesFile);
        fileToLoad.put(CoserConstants.Category.STRATA, stratesFile);
        fileToLoad.put(CoserConstants.Category.REFTAX_SPECIES, reftaxSpeciesFile);
        fileToLoad.put(CoserConstants.Category.TYPE_ESPECES, codeTypeEspeceFile);
        projectView.getCreateProjectButton().setEnabled(false);
        this.setWaitCursor((Component)((Object)projectView));
        SwingWorker<Project, Void> task = new SwingWorker<Project, Void>(){
            protected long before = System.currentTimeMillis();

            @Override
            protected Project doInBackground() {
                ProjectService projectService = projectView.getContextValue(ProjectService.class);
                Project resultProject = null;
                try {
                    resultProject = projectService.createProject(project, fileToLoad, newMaps, (ProgressMonitor)projectView.getLoadProgressBar());
                }
                catch (CoserBusinessException ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't create project", (Throwable)ex);
                    }
                    projectView.getCreateProjectButton().setEnabled(true);
                    projectView.getLoadProgressBar().setValue(0);
                    throw new CoserException(ex.getMessage(), ex);
                }
                return resultProject;
            }

            @Override
            protected void done() {
                if (log.isInfoEnabled()) {
                    long after = System.currentTimeMillis();
                    log.info((Object)("4 import take " + (after - this.before) + "ms"));
                }
                try {
                    Project resultProject = (Project)this.get();
                    if (resultProject != null) {
                        parent.getHandler().projectLoaded(resultProject);
                        parent.getHandler().showControlView(false);
                    }
                }
                catch (Exception ex) {
                    throw new CoserException(ex.getMessage(), ex);
                }
                finally {
                    ProjectHandler.this.setDefaultCursor((Component)((Object)projectView));
                }
            }
        };
        task.execute();
    }

    public void saveProject(ProjectEditView projectView) {
        Project project = projectView.getProject();
        ProjectService projectService = projectView.getContextValue(ProjectService.class);
        CoserFrame parent = projectView.getContextValue(CoserFrame.class, "parent");
        this.setWaitCursor((Component)((Object)projectView));
        try {
            List<File> newMaps = projectView.getProjectMapsModel().getMaps();
            projectService.saveProject(project, newMaps);
            parent.getHandler().showSummaryView();
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't save project", ex);
        }
        finally {
            this.setDefaultCursor((Component)((Object)projectView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(ProjectOpenView projectView) {
        int selectedIndex = projectView.getProjectsList().getSelectedIndex();
        String projectName = (String)projectView.getProjectsList().getModel().getElementAt(selectedIndex);
        ProjectService projectService = projectView.getContextValue(ProjectService.class);
        CoserFrame parent = projectView.getContextValue(CoserFrame.class, "parent");
        try {
            this.setWaitCursor((Component)((Object)projectView));
            Project project = projectService.openProject(projectName);
            parent.getHandler().projectLoaded(project);
            parent.getHandler().showSummaryView();
        }
        catch (CoserBusinessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't open project", (Throwable)ex);
            }
            JOptionPane.showMessageDialog((Component)((Object)projectView), ex.getMessage(), I18n._((String)"coser.ui.project.openError", (Object[])new Object[0]), 0);
        }
        finally {
            this.setDefaultCursor((Component)((Object)projectView));
        }
    }

    public void loadProjectOnDoubleClick(ProjectOpenView projectView, MouseEvent event) {
        int selectedIndex;
        if (event.getButton() == 1 && event.getClickCount() == 2 && (selectedIndex = projectView.getProjectsList().getSelectedIndex()) >= 0) {
            this.loadProject(projectView);
        }
    }
}

