/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.control.DiffCatchLengthControlError;
import fr.ifremer.coser.data.AbstractDataEntity;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.services.ControlService;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.services.PublicationService;
import fr.ifremer.coser.ui.common.DataHandler;
import fr.ifremer.coser.ui.control.ControlDuplicatedLineTableModel;
import fr.ifremer.coser.ui.control.ControlFindReplaceDialog;
import fr.ifremer.coser.ui.control.ControlGraphFrame;
import fr.ifremer.coser.ui.control.ControlTableModel;
import fr.ifremer.coser.ui.control.ControlView;
import fr.ifremer.coser.ui.control.GlobalControlErrorModel;
import fr.ifremer.coser.ui.util.CoserProgressBar;
import fr.ifremer.coser.util.ProgressMonitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.SwingSession;

public class ControlHandler
extends DataHandler {
    private static final Log log = LogFactory.getLog(ControlHandler.class);

    public void init(ControlView controlView) {
        CoserConfig config = controlView.getContextValue(CoserConfig.class);
        boolean localUsed = config.getValidatorsDirectory().isDirectory();
        controlView.getLocalControlUsedLabel().setVisible(localUsed);
    }

    protected JTable getControlDataTable(ControlView controlView) {
        CoserConstants.Category category = (CoserConstants.Category)controlView.getCategoryComboBox().getSelectedItem();
        JTable controlDataTable = null;
        switch (category) {
            case CATCH: {
                controlDataTable = controlView.getControlDataTableCatch();
                break;
            }
            case HAUL: {
                controlDataTable = controlView.getControlDataTableHaul();
                break;
            }
            case LENGTH: {
                controlDataTable = controlView.getControlDataTableLength();
                break;
            }
            case STRATA: {
                controlDataTable = controlView.getControlDataTableStrata();
            }
        }
        return controlDataTable;
    }

    public void categoryChanged(ControlView controlView, ActionEvent event) {
        CoserConstants.Category category = (CoserConstants.Category)controlView.getCategoryComboBox().getSelectedItem();
        controlView.getControlTablesLayout().show(controlView.getControlTablesPanel(), category.toString());
        this.clearAllSelection(controlView);
    }

    protected void clearAllSelection(ControlView controlView) {
        controlView.getControlDataTableSelectionModelCatch().clearSelection();
        controlView.getControlDataTableSelectionModelHaul().clearSelection();
        controlView.getControlDataTableSelectionModelLength().clearSelection();
        controlView.getControlDataTableSelectionModelStrata().clearSelection();
    }

    public void showDataTableContextMenu(final ControlView controlView, MouseEvent event) {
        if (event.getButton() == 3) {
            JTable displayedTable = this.getControlDataTable(controlView);
            int[] dataSelectedRows = displayedTable.getSelectedRows();
            final int columnIndex = displayedTable.getColumnModel().getColumnIndexAtX(event.getX());
            JPopupMenu popupMenu = new JPopupMenu(I18n._((String)"coser.ui.control.dataMenuLabel", (Object[])new Object[0]));
            if (dataSelectedRows.length > 0 && columnIndex > 0) {
                ControlTableModel controlDataModel = (ControlTableModel)displayedTable.getModel();
                final String columnName = displayedTable.getColumnName(columnIndex);
                final String firstValue = (String)controlDataModel.getValueAt(dataSelectedRows[0], columnIndex);
                JMenuItem replaceMenu = new JMenuItem(I18n._((String)"coser.ui.control.dataMenuReplace", (Object[])new Object[]{columnName}));
                replaceMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlFindReplaceDialog viewDialog = new ControlFindReplaceDialog((JAXXContext)controlView);
                        viewDialog.setHandler(ControlHandler.this);
                        viewDialog.setColumnIndex(columnIndex);
                        viewDialog.setReplaceInSelection(true);
                        viewDialog.getReplaceFieldNameLabel().setText(columnName);
                        viewDialog.getReplaceFindField().setText(firstValue);
                        viewDialog.setLocationRelativeTo((Component)((Object)controlView));
                        viewDialog.setVisible(true);
                    }
                });
                popupMenu.add(replaceMenu);
            }
            if (columnIndex > 0) {
                final String columnName = displayedTable.getColumnName(columnIndex);
                JMenuItem replaceAllMenu = new JMenuItem(I18n._((String)"coser.ui.control.dataMenuReplaceAll", (Object[])new Object[]{columnName}));
                replaceAllMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlFindReplaceDialog viewDialog = new ControlFindReplaceDialog((JAXXContext)controlView);
                        viewDialog.setHandler(ControlHandler.this);
                        viewDialog.setColumnIndex(columnIndex);
                        viewDialog.getReplaceFieldNameLabel().setText(columnName);
                        viewDialog.setLocationRelativeTo((Component)((Object)controlView));
                        viewDialog.setVisible(true);
                    }
                });
                popupMenu.add(replaceAllMenu);
            }
            if (dataSelectedRows.length > 0) {
                JMenuItem deleteSelectedMenu = new JMenuItem(I18n._((String)"coser.ui.control.dataMenuDeleteSelected", (Object[])new Object[0]));
                deleteSelectedMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlHandler.this.deletedSelectedDataLines(controlView);
                    }
                });
                popupMenu.add(deleteSelectedMenu);
            }
            popupMenu.show(displayedTable, event.getX(), event.getY());
        }
    }

    protected void deletedSelectedDataLines(ControlView controlView) {
        int response;
        JTable controlDataTable = this.getControlDataTable(controlView);
        int[] selectedLines = controlDataTable.getSelectedRows();
        if (ArrayUtils.isNotEmpty((int[])selectedLines) && (response = JOptionPane.showConfirmDialog((Component)((Object)controlView), I18n._((String)"coser.ui.control.confirmDeletionsMessage", (Object[])new Object[]{selectedLines.length}), I18n._((String)"coser.ui.control.confirmDeletionTitle", (Object[])new Object[0]), 0, 3)) == 0) {
            this.disableValidAction(controlView);
            Project project = controlView.getContextValue(Project.class);
            ProjectService projectService = controlView.getContextValue(ProjectService.class);
            CoserConstants.Category category = (CoserConstants.Category)controlView.getCategoryComboBox().getSelectedItem();
            ControlTableModel model = (ControlTableModel)controlDataTable.getModel();
            String commandUUID = UUID.randomUUID().toString();
            for (int indexSelected = selectedLines.length - 1; indexSelected >= 0; --indexSelected) {
                int selectedLine = selectedLines[indexSelected];
                String[] data = model.getDataAt(selectedLine);
                try {
                    projectService.deleteData(project, project.getControl(), category, data[0], commandUUID);
                    model.fireTableRowsDeleted(selectedLine, selectedLine);
                    continue;
                }
                catch (CoserBusinessException ex) {
                    throw new CoserException("Can't delete data", ex);
                }
            }
        }
    }

    public void performFindAndReplace(ControlFindReplaceDialog replaceView) {
        ControlView controlView = replaceView.getContextValue(ControlView.class, "parent");
        CoserConstants.Category category = (CoserConstants.Category)controlView.getCategoryComboBox().getSelectedItem();
        JTable displayedTable = this.getControlDataTable(controlView);
        ControlTableModel controlDataModel = (ControlTableModel)displayedTable.getModel();
        ProjectService projectService = replaceView.getContextValue(ProjectService.class);
        Project project = replaceView.getContextValue(Project.class);
        String[] enHeaders = null;
        switch (category) {
            case CATCH: {
                enHeaders = Catch.EN_HEADERS;
                break;
            }
            case HAUL: {
                enHeaders = Haul.EN_HEADERS;
                break;
            }
            case LENGTH: {
                enHeaders = Length.EN_HEADERS;
                break;
            }
            case STRATA: {
                enHeaders = Strata.EN_HEADERS;
            }
        }
        String field = enHeaders[replaceView.getColumnIndex() - 1];
        String find = replaceView.getReplaceFindField().getText();
        String replace = replaceView.getReplaceReplaceField().getText();
        if (log.isWarnEnabled()) {
            log.warn((Object)("Perform : " + find + " replace with " + replace));
        }
        String commandUUID = UUID.randomUUID().toString();
        try {
            int replaceCount = 0;
            if (replaceView.isReplaceInSelection().booleanValue()) {
                int[] dataSelectedRows;
                for (int dataSelectedRow : dataSelectedRows = displayedTable.getSelectedRows()) {
                    String[] data = controlDataModel.getDataAt(dataSelectedRow);
                    boolean replaced = projectService.replaceFieldValue(project, category, field, find, replace, data, false, commandUUID);
                    if (!replaced) continue;
                    controlDataModel.fireTableRowsUpdated(dataSelectedRow, dataSelectedRow);
                    ++replaceCount;
                }
            } else {
                int rowCount = controlDataModel.getRowCount();
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    String[] data = controlDataModel.getDataAt(rowIndex);
                    boolean replaced = projectService.replaceFieldValue(project, category, field, find, replace, data, false, commandUUID);
                    if (!replaced) continue;
                    controlDataModel.fireTableRowsUpdated(rowIndex, rowIndex);
                    ++replaceCount;
                }
            }
            JOptionPane.showMessageDialog(replaceView, I18n._((String)"coser.ui.control.replace.replacedCount", (Object[])new Object[]{replaceCount}), I18n._((String)"coser.ui.control.replace.title", (Object[])new Object[0]), 1);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't replace field value", ex);
        }
        replaceView.dispose();
        this.controlDataTableSelectionChanged(controlView);
    }

    public void checkData(final ControlView view) {
        this.clearAllSelection(view);
        final ControlService validationService = view.getContextValue(ControlService.class);
        final Project project = view.getContextValue(Project.class);
        final CoserProgressBar progressBar = view.getCheckProgressBar();
        SwingWorker<List<ControlError>, Void> task = new SwingWorker<List<ControlError>, Void>(){
            protected long before = System.currentTimeMillis();

            @Override
            protected List<ControlError> doInBackground() {
                List validationErrors = validationService.validateData(project, project.getControl(), (ProgressMonitor)progressBar);
                return validationErrors;
            }

            @Override
            protected void done() {
                if (log.isInfoEnabled()) {
                    long after = System.currentTimeMillis();
                    log.info((Object)("Validation file checked in " + (after - this.before) + "ms"));
                }
                try {
                    PublicationService publicationService = view.getContextValue(PublicationService.class);
                    Map charts = publicationService.getCompareCatchLengthGraph(project, (AbstractDataContainer)project.getControl(), null);
                    view.setContextValue(charts, "CompareCatchLengthGraph");
                    view.getCompareNumberCatchLengthButton().setEnabled(true);
                    view.getGlobalControlErrorTable().setAutoCreateColumnsFromModel(false);
                    List errors = (List)this.get();
                    view.getGlobalControlErrorModel().setControlErrors(errors);
                    ControlDuplicatedLineTableModel catchModel = (ControlDuplicatedLineTableModel)view.getControlDataTableCatch().getModel();
                    catchModel.setControlErrors(errors);
                    catchModel = (ControlDuplicatedLineTableModel)view.getControlDataTableStrata().getModel();
                    catchModel.setControlErrors(errors);
                    catchModel = (ControlDuplicatedLineTableModel)view.getControlDataTableHaul().getModel();
                    catchModel.setControlErrors(errors);
                    catchModel = (ControlDuplicatedLineTableModel)view.getControlDataTableLength().getModel();
                    catchModel.setControlErrors(errors);
                    boolean errorFound = false;
                    Iterator itError = errors.iterator();
                    while (itError.hasNext() && !errorFound) {
                        ControlError error = (ControlError)itError.next();
                        if (error.getLevel() != CoserConstants.ValidationLevel.ERROR && error.getLevel() != CoserConstants.ValidationLevel.FATAL) continue;
                        errorFound = true;
                    }
                    view.setCanValidControl(!errorFound);
                }
                catch (Exception ex) {
                    throw new CoserException("Can't validate data", ex);
                }
            }
        };
        task.execute();
    }

    public void controlDataTableSelectionChanged(ControlView view) {
        JTable table = this.getControlDataTable(view);
        ControlTableModel model = (ControlTableModel)table.getModel();
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length == 1) {
            int selectedRow = selectedRows[0];
            Project project = view.getContextValue(Project.class);
            CoserConstants.Category category = (CoserConstants.Category)view.getCategoryComboBox().getSelectedItem();
            String[] header = null;
            String[] line = null;
            switch (category) {
                case CATCH: {
                    header = project.getControl().getCatch().get(0);
                    break;
                }
                case HAUL: {
                    header = project.getControl().getHaul().get(0);
                    break;
                }
                case LENGTH: {
                    header = project.getControl().getLength().get(0);
                    break;
                }
                case STRATA: {
                    header = project.getControl().getStrata().get(0);
                }
            }
            line = model.getDataAt(selectedRow);
            this.updateEditionPanel(view, category, header, line);
        } else {
            this.updateEditionPanel(view, null, null, null);
        }
    }

    public void showSelectedError(ControlView view, TreeSelectionEvent event) {
        Object[] pathWay;
        TreePath selectedError = view.getGlobalControlErrorTable().getTreeSelectionModel().getSelectionPath();
        if (selectedError != null && (pathWay = selectedError.getPath()).length == 4 && pathWay[1] instanceof CoserConstants.Category) {
            CoserConstants.Category category = (CoserConstants.Category)pathWay[1];
            view.getCategoryComboBoxModel().setSelectedItem(category);
            ControlError error = (ControlError)pathWay[3];
            List errorLineNumbers = error.getLineNumbers();
            if (errorLineNumbers != null) {
                JTable displayedTable = this.getControlDataTable(view);
                ControlTableModel tableModel = (ControlTableModel)displayedTable.getModel();
                ListSelectionModel selectionModel = displayedTable.getSelectionModel();
                selectionModel.clearSelection();
                boolean first = true;
                for (String errorLineNumber : errorLineNumbers) {
                    int errorLineIndex = tableModel.getRealIndexOfLine(errorLineNumber);
                    if (errorLineIndex < 0) continue;
                    selectionModel.addSelectionInterval(errorLineIndex, errorLineIndex);
                    if (!first) continue;
                    this.scrollToVisible(displayedTable, errorLineIndex, 0);
                    first = false;
                }
            }
        }
    }

    public void globalErrorTableMouseCLicked(final ControlView controlView, MouseEvent event) {
        Object[] pathWay;
        Object lastComponent;
        TreePath selectedError;
        int eventButton = event.getButton();
        if (eventButton == 3) {
            Object[] pathWay2;
            JXTreeTable errorTable = controlView.getGlobalControlErrorTable();
            TreePath selectedError2 = errorTable.getTreeSelectionModel().getSelectionPath();
            JPopupMenu popupMenu = new JPopupMenu();
            if (selectedError2 != null && (pathWay2 = selectedError2.getPath()).length == 3 && pathWay2[1] instanceof CoserConstants.Category) {
                final CoserConstants.Category category = (CoserConstants.Category)pathWay2[1];
                final ControlErrorGroup validationGroup = (ControlErrorGroup)pathWay2[2];
                JMenuItem replaceMenu = new JMenuItem(I18n._((String)"coser.ui.control.globalErrorMenuSelectAll", (Object[])new Object[0]));
                replaceMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlHandler.this.selectAllErrorGroupLines(controlView, category, validationGroup);
                    }
                });
                popupMenu.add(replaceMenu);
                popupMenu.add(new JSeparator());
            }
            if (errorTable.getRowCount() > 0) {
                JMenuItem generateHtmlMenu = new JMenuItem(I18n._((String)"coser.ui.control.globalErrorMenuGenerateHTML", (Object[])new Object[0]));
                generateHtmlMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlHandler.this.generateHTMLReport(controlView);
                    }
                });
                popupMenu.add(generateHtmlMenu);
            }
            popupMenu.show((Component)controlView.getGlobalControlErrorTable(), event.getX(), event.getY());
        } else if (eventButton == 1 && event.getClickCount() == 2 && (selectedError = controlView.getGlobalControlErrorTable().getTreeSelectionModel().getSelectionPath()) != null && (lastComponent = (pathWay = selectedError.getPath())[pathWay.length - 1]) instanceof DiffCatchLengthControlError) {
            DiffCatchLengthControlError error = (DiffCatchLengthControlError)lastComponent;
            String species = error.getSpecies();
            this.displayCompareNumberCatchGraph(controlView, species);
        }
    }

    protected void selectAllErrorGroupLines(ControlView controlView, CoserConstants.Category category, ControlErrorGroup validationGroup) {
        controlView.getCategoryComboBoxModel().setSelectedItem(category);
        GlobalControlErrorModel model = controlView.getGlobalControlErrorModel();
        JTable displayedTable = this.getControlDataTable(controlView);
        ControlTableModel tableModel = (ControlTableModel)displayedTable.getModel();
        ListSelectionModel selectionModel = displayedTable.getSelectionModel();
        selectionModel.clearSelection();
        boolean first = true;
        int childCount = model.getChildCount(validationGroup);
        for (int indexChild = 0; indexChild < childCount; ++indexChild) {
            ControlError validationError = (ControlError)model.getChild(validationGroup, indexChild);
            List errorLineNumbers = validationError.getLineNumbers();
            for (String errorLineNumber : errorLineNumbers) {
                int errorLineIndex = tableModel.getRealIndexOfLine(errorLineNumber);
                if (errorLineIndex < 0) continue;
                selectionModel.addSelectionInterval(errorLineIndex, errorLineIndex);
                if (!first) continue;
                this.scrollToVisible(displayedTable, errorLineIndex, 0);
                first = false;
            }
        }
    }

    protected void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    protected void generateHTMLReport(ControlView controlView) {
        PublicationService publicationService = controlView.getContextValue(PublicationService.class);
        Project project = controlView.getContextValue(Project.class);
        List<ControlError> controlErrors = controlView.getGlobalControlErrorModel().getControlErrors();
        File htmlFile = null;
        try {
            htmlFile = publicationService.exportErrorsAsHTML(project, (AbstractDataContainer)project.getControl(), controlErrors);
            this.browseFile((Component)((Object)controlView), htmlFile);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't generate html report", ex);
        }
    }

    protected void updateEditionPanel(ControlView view, CoserConstants.Category category, String[] header, String[] line) {
        JPanel panel = view.getEditionPanel();
        panel.removeAll();
        if (category != null && header != null && line != null) {
            Catch beanCatch = null;
            Haul beanHaul = null;
            Length beanLength = null;
            Strata beanStrata = null;
            Catch bean = null;
            SwingValidator<Catch> validator = null;
            switch (category) {
                case CATCH: {
                    beanCatch = new Catch();
                    beanCatch.setData(line);
                    bean = beanCatch;
                    validator = view.getValidatorCatch();
                    break;
                }
                case HAUL: {
                    beanHaul = new Haul();
                    beanHaul.setData(line);
                    bean = beanHaul;
                    validator = view.getValidatorHaul();
                    break;
                }
                case LENGTH: {
                    beanLength = new Length();
                    beanLength.setData(line);
                    bean = beanLength;
                    validator = view.getValidatorLength();
                    break;
                }
                case STRATA: {
                    beanStrata = new Strata();
                    beanStrata.setData(line);
                    bean = beanStrata;
                    validator = view.getValidatorStrata();
                }
            }
            view.getValidatorCatch().setBean((Object)beanCatch);
            view.getValidatorHaul().setBean((Object)beanHaul);
            view.getValidatorLength().setBean((Object)beanLength);
            view.getValidatorStrata().setBean((Object)beanStrata);
            Catch finalBean = bean;
            for (int fieldIndex = 1; fieldIndex < header.length; ++fieldIndex) {
                String headerValue = header[fieldIndex];
                String fieldValue = line[fieldIndex];
                String beanFieldName = Introspector.decapitalize(bean.getHeaders()[fieldIndex - 1]);
                String stringBeanFieldName = beanFieldName + "AsString";
                JLabel label = new JLabel(headerValue + "\u2009:");
                JTextField fieldTextField = new JTextField(fieldValue);
                fieldTextField.getDocument().addDocumentListener(new DocumentListener((AbstractDataEntity)finalBean, stringBeanFieldName, fieldTextField){
                    final /* synthetic */ AbstractDataEntity val$finalBean;
                    final /* synthetic */ String val$stringBeanFieldName;
                    final /* synthetic */ JTextField val$fieldTextField;
                    {
                        this.val$finalBean = abstractDataEntity;
                        this.val$stringBeanFieldName = string;
                        this.val$fieldTextField = jTextField;
                    }

                    @Override
                    public void insertUpdate(DocumentEvent event) {
                        this.valueChanged(event);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent event) {
                        this.valueChanged(event);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent event) {
                        this.valueChanged(event);
                    }

                    protected void valueChanged(DocumentEvent event) {
                        block2: {
                            try {
                                PropertyUtils.setProperty((Object)this.val$finalBean, (String)this.val$stringBeanFieldName, (Object)this.val$fieldTextField.getText());
                            }
                            catch (Exception ex) {
                                if (!log.isErrorEnabled()) break block2;
                                log.error((Object)("Can't set property value (" + this.val$stringBeanFieldName + ")"), (Throwable)ex);
                            }
                        }
                    }
                });
                panel.add((Component)label, new GridBagConstraints(0, fieldIndex, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
                panel.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)fieldTextField), new GridBagConstraints(1, fieldIndex, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
                validator.setFieldRepresentation(beanFieldName, (JComponent)fieldTextField);
                validator.setFieldRepresentation(stringBeanFieldName, (JComponent)fieldTextField);
            }
            validator.installUIs();
            validator.reloadBean();
            view.getControlDataValidButton().setEnabled(true);
            view.getControlDataCancelButton().setEnabled(true);
            view.getControlDataDeleteButton().setEnabled(true);
        } else {
            view.getValidatorCatch().setBean(null);
            view.getValidatorHaul().setBean(null);
            view.getValidatorLength().setBean(null);
            view.getValidatorStrata().setBean(null);
            view.getControlDataValidButton().setEnabled(false);
            view.getControlDataCancelButton().setEnabled(false);
            view.getControlDataDeleteButton().setEnabled(false);
        }
        view.getEditionScrollPane().repaint();
        view.getEditionScrollPane().validate();
    }

    public void saveControl(ControlView view) {
        this.saveProjectControl(view);
        JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.control.controlSaved", (Object[])new Object[0]), I18n._((String)"coser.ui.control.controlTitle", (Object[])new Object[0]), 1);
    }

    protected void saveProjectControl(ControlView view) {
        Project project = view.getContextValue(Project.class);
        ProjectService service = view.getContextValue(ProjectService.class);
        try {
            long before = System.currentTimeMillis();
            service.saveProjectControl(project);
            if (log.isDebugEnabled()) {
                long after = System.currentTimeMillis();
                log.debug((Object)("Control files saved in " + (after - before) + "ms"));
            }
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't save project control", ex);
        }
    }

    public void displayCompareNumberCatchGraph(ControlView view) {
        this.displayCompareNumberCatchGraph(view, null);
    }

    public void displayCompareNumberCatchGraph(ControlView view, String selectedSpecies) {
        SwingSession session = view.getContextValue(SwingSession.class);
        Map charts = view.getContextValue(Map.class, "CompareCatchLengthGraph");
        ArrayList<String> species = new ArrayList<String>(charts.keySet());
        JFrame previousFrame = view.getContextValue(JFrame.class, "comparenumberframe");
        if (previousFrame != null) {
            previousFrame.dispose();
        }
        ControlGraphFrame frame = new ControlGraphFrame((JAXXContext)view);
        frame.setHandler(this);
        frame.setContextValue(charts);
        frame.getSpecyComboModel().setSpecy(species);
        if (selectedSpecies != null) {
            frame.getSpecyComboModel().setSelectedItem(selectedSpecies);
            this.updateCompareNumberCatchGraph(frame);
        }
        frame.pack();
        frame.setLocationRelativeTo((Component)((Object)view));
        session.add((Component)frame);
        frame.toFront();
        frame.setVisible(true);
        view.setContextValue(frame, "comparenumberframe");
    }

    public void displayLengthStructureGraph(ControlView view) {
        Project project = view.getContextValue(Project.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        SwingSession session = view.getContextValue(SwingSession.class);
        this.displayLengthStructureGraph((Component)((Object)view), session, projectService, project, (AbstractDataContainer)project.getControl());
    }

    public void updateCompareNumberCatchGraph(ControlGraphFrame view) {
        String specyName = (String)view.getSpecyComboModel().getSelectedItem();
        Map charts = view.getContextValue(Map.class, "CompareCatchLengthGraph");
        JFreeChart chart = (JFreeChart)charts.get(specyName);
        view.getControlGraphPanel().removeAll();
        ChartPanel chartPanel = new ChartPanel(chart);
        view.getControlGraphPanel().add((Component)chartPanel, "Center");
        view.getControlGraphPanel().validate();
    }

    public void validDataModification(ControlView view) {
        this.disableValidAction(view);
        Project project = view.getContextValue(Project.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        JTable controlDataTable = this.getControlDataTable(view);
        ControlTableModel model = (ControlTableModel)controlDataTable.getModel();
        int selectedLine = controlDataTable.getSelectedRow();
        CoserConstants.Category category = (CoserConstants.Category)view.getCategoryComboBox().getSelectedItem();
        String[] newData = null;
        switch (category) {
            case CATCH: {
                Catch beanCatch = (Catch)view.getValidatorCatch().getBean();
                newData = beanCatch.getData();
                break;
            }
            case HAUL: {
                Haul beanHaul = (Haul)view.getValidatorHaul().getBean();
                newData = beanHaul.getData();
                break;
            }
            case LENGTH: {
                Length beanLength = (Length)view.getValidatorLength().getBean();
                newData = beanLength.getData();
                break;
            }
            case STRATA: {
                Strata beanStrata = (Strata)view.getValidatorStrata().getBean();
                newData = beanStrata.getData();
            }
        }
        try {
            projectService.replaceData(project, project.getControl(), category, newData);
            model.fireTableRowsUpdated(selectedLine, selectedLine);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't replace data", ex);
        }
    }

    public void cancelDataModification(ControlView view) {
        this.controlDataTableSelectionChanged(view);
    }

    public void deleteData(ControlView view) {
        int response = JOptionPane.showConfirmDialog((Component)((Object)view), I18n._((String)"coser.ui.control.confirmDeletionMessage", (Object[])new Object[0]), I18n._((String)"coser.ui.control.confirmDeletionTitle", (Object[])new Object[0]), 0, 2);
        if (response == 0) {
            this.disableValidAction(view);
            Project project = view.getContextValue(Project.class);
            ProjectService projectService = view.getContextValue(ProjectService.class);
            JTable controlDataTable = this.getControlDataTable(view);
            ControlTableModel model = (ControlTableModel)controlDataTable.getModel();
            int selectedLine = controlDataTable.getSelectedRow();
            CoserConstants.Category category = (CoserConstants.Category)view.getCategoryComboBox().getSelectedItem();
            String[] data = model.getDataAt(selectedLine);
            try {
                projectService.deleteData(project, project.getControl(), category, data[0]);
                model.fireTableRowsDeleted(selectedLine, selectedLine);
            }
            catch (CoserBusinessException ex) {
                throw new CoserException("Can't delete data", ex);
            }
        }
    }

    protected void disableValidAction(ControlView view) {
        Project project = view.getContextValue(Project.class);
        project.getControl().setValidated(false);
        view.setCanValidControl(false);
    }

    public void validControl(ControlView view) {
        Project project = view.getContextValue(Project.class);
        project.getControl().setValidated(true);
        this.saveProjectControl(view);
        JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.control.controlValidated", (Object[])new Object[0]), I18n._((String)"coser.ui.control.controlTitle", (Object[])new Object[0]), 1);
    }

    public void displayLogReport(ControlView controlView) {
        PublicationService publicationService = controlView.getContextValue(PublicationService.class);
        Project project = controlView.getContextValue(Project.class);
        File htmlFile = null;
        try {
            htmlFile = publicationService.extractControlLogAsHTML(project, project.getControl());
            this.browseFile((Component)((Object)controlView), htmlFile);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't generate html report", ex);
        }
    }
}

